/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.paimon.data.columnar.writable.WritableByteVector;
import org.apache.paimon.data.columnar.writable.WritableColumnVector;
import org.apache.paimon.data.columnar.writable.WritableIntVector;
import org.apache.paimon.data.columnar.writable.WritableLongVector;
import org.apache.paimon.data.columnar.writable.WritableShortVector;
import org.apache.paimon.format.parquet.reader.VectorizedReaderBase;
import org.apache.paimon.format.parquet.reader.VectorizedValuesReader;
import org.apache.paimon.shade.org.apache.parquet.Preconditions;
import org.apache.paimon.shade.org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.paimon.shade.org.apache.parquet.bytes.BytesUtils;
import org.apache.paimon.shade.org.apache.parquet.column.values.bitpacking.BytePackerForLong;
import org.apache.paimon.shade.org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.paimon.shade.org.apache.parquet.io.ParquetDecodingException;

public class VectorizedDeltaBinaryPackedReader
extends VectorizedReaderBase {
    private int blockSizeInValues;
    private int miniBlockNumInABlock;
    private int totalValueCount;
    private long firstValue;
    private int miniBlockSizeInValues;
    private int valuesRead = 0;
    private long lastValueRead;
    private long minDeltaInCurrentBlock;
    private int currentMiniBlock = 0;
    private int[] bitWidths;
    private int remainingInBlock = 0;
    private int remainingInMiniBlock = 0;
    private long[] unpackedValuesBuffer;
    private ByteBufferInputStream in;
    private byte byteVal;
    private short shortVal;
    private int intVal;
    private long longVal;

    @Override
    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        Preconditions.checkArgument(valueCount >= 1, "Page must have at least one value, but it has " + valueCount);
        this.in = in;
        this.blockSizeInValues = BytesUtils.readUnsignedVarInt(in);
        this.miniBlockNumInABlock = BytesUtils.readUnsignedVarInt(in);
        double miniSize = (double)this.blockSizeInValues / (double)this.miniBlockNumInABlock;
        Preconditions.checkArgument(miniSize % 8.0 == 0.0, "miniBlockSize must be multiple of 8, but it's " + miniSize);
        this.miniBlockSizeInValues = (int)miniSize;
        this.totalValueCount = BytesUtils.readUnsignedVarInt(in);
        this.bitWidths = new int[this.miniBlockNumInABlock];
        this.unpackedValuesBuffer = new long[this.miniBlockSizeInValues];
        this.firstValue = BytesUtils.readZigZagVarLong(in);
    }

    int getTotalValueCount() {
        return this.totalValueCount;
    }

    @Override
    public byte readByte() {
        this.readValues(1, null, 0, (w, r, v) -> {
            this.byteVal = (byte)v;
        });
        return this.byteVal;
    }

    @Override
    public short readShort() {
        this.readValues(1, null, 0, (w, r, v) -> {
            this.shortVal = (short)v;
        });
        return this.shortVal;
    }

    @Override
    public int readInteger() {
        this.readValues(1, null, 0, (w, r, v) -> {
            this.intVal = (int)v;
        });
        return this.intVal;
    }

    @Override
    public long readLong() {
        this.readValues(1, null, 0, (w, r, v) -> {
            this.longVal = v;
        });
        return this.longVal;
    }

    @Override
    public void readBytes(int total, WritableByteVector c, int rowId) {
        this.readValues(total, c, rowId, (w, r, v) -> ((WritableByteVector)w).setByte(r, (byte)v));
    }

    @Override
    public void readShorts(int total, WritableShortVector c, int rowId) {
        this.readValues(total, c, rowId, (w, r, v) -> ((WritableShortVector)w).setShort(r, (short)v));
    }

    @Override
    public void readIntegers(int total, WritableIntVector c, int rowId) {
        this.readValues(total, c, rowId, (w, r, v) -> ((WritableIntVector)w).setInt(r, (int)v));
    }

    @Override
    public void readLongs(int total, WritableLongVector c, int rowId) {
        this.readValues(total, c, rowId, (w, r, v) -> ((WritableLongVector)w).setLong(r, v));
    }

    @Override
    public void skipBytes(int total) {
        this.skipValues(total);
    }

    @Override
    public void skipShorts(int total) {
        this.skipValues(total);
    }

    @Override
    public void skipIntegers(int total) {
        this.skipValues(total);
    }

    @Override
    public void skipLongs(int total) {
        this.skipValues(total);
    }

    private void readValues(int total, WritableColumnVector c, int rowId, VectorizedValuesReader.IntegerOutputWriter outputWriter) {
        if (this.valuesRead + total > this.totalValueCount) {
            throw new ParquetDecodingException("No more values to read. Total values read:  " + this.valuesRead + ", total count: " + this.totalValueCount + ", trying to read " + total + " more.");
        }
        int remaining = total;
        if (this.valuesRead == 0) {
            outputWriter.write(c, rowId, this.firstValue);
            this.lastValueRead = this.firstValue;
            ++rowId;
            --remaining;
        }
        while (remaining > 0) {
            int n;
            try {
                n = this.loadMiniBlockToOutput(remaining, c, rowId, outputWriter);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Error reading mini block.", e);
            }
            rowId += n;
            remaining -= n;
        }
        this.valuesRead = total - remaining;
    }

    private int loadMiniBlockToOutput(int remaining, WritableColumnVector c, int rowId, VectorizedValuesReader.IntegerOutputWriter outputWriter) throws IOException {
        if (this.remainingInBlock == 0) {
            this.readBlockHeader();
        }
        if (this.remainingInMiniBlock == 0) {
            this.unpackMiniBlock();
        }
        int valuesRead = 0;
        for (int i = this.miniBlockSizeInValues - this.remainingInMiniBlock; i < this.miniBlockSizeInValues && valuesRead < remaining; ++valuesRead, ++i) {
            long outValue;
            this.lastValueRead = outValue = this.lastValueRead + this.minDeltaInCurrentBlock + this.unpackedValuesBuffer[i];
            outputWriter.write(c, rowId + valuesRead, outValue);
            --this.remainingInBlock;
            --this.remainingInMiniBlock;
        }
        return valuesRead;
    }

    private void readBlockHeader() {
        try {
            this.minDeltaInCurrentBlock = BytesUtils.readZigZagVarLong(this.in);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Can not read min delta in current block", e);
        }
        this.readBitWidthsForMiniBlocks();
        this.remainingInBlock = this.blockSizeInValues;
        this.currentMiniBlock = 0;
        this.remainingInMiniBlock = 0;
    }

    private void unpackMiniBlock() throws IOException {
        Arrays.fill(this.unpackedValuesBuffer, 0L);
        BytePackerForLong packer = Packer.LITTLE_ENDIAN.newBytePackerForLong(this.bitWidths[this.currentMiniBlock]);
        for (int j = 0; j < this.miniBlockSizeInValues; j += 8) {
            ByteBuffer buffer = this.in.slice(packer.getBitWidth());
            if (buffer.hasArray()) {
                packer.unpack8Values(buffer.array(), buffer.arrayOffset() + buffer.position(), this.unpackedValuesBuffer, j);
                continue;
            }
            packer.unpack8Values(buffer, buffer.position(), this.unpackedValuesBuffer, j);
        }
        this.remainingInMiniBlock = this.miniBlockSizeInValues;
        ++this.currentMiniBlock;
    }

    private void readBitWidthsForMiniBlocks() {
        for (int i = 0; i < this.miniBlockNumInABlock; ++i) {
            try {
                this.bitWidths[i] = BytesUtils.readIntLittleEndianOnOneByte(this.in);
                continue;
            }
            catch (IOException e) {
                throw new ParquetDecodingException("Can not decode bitwidth in block header", e);
            }
        }
    }

    private void skipValues(int total) {
        this.readValues(total, null, -1, (w, r, v) -> {});
    }
}

