/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.paimon.io.DataFileMeta;

public class DataIncrement {
    private final List<DataFileMeta> newFiles;
    private final List<DataFileMeta> deletedFiles;
    private final List<DataFileMeta> changelogFiles;

    public DataIncrement(List<DataFileMeta> newFiles, List<DataFileMeta> deletedFiles, List<DataFileMeta> changelogFiles) {
        this.newFiles = newFiles;
        this.deletedFiles = deletedFiles;
        this.changelogFiles = changelogFiles;
    }

    public static DataIncrement emptyIncrement() {
        return new DataIncrement(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    public List<DataFileMeta> newFiles() {
        return this.newFiles;
    }

    public List<DataFileMeta> deletedFiles() {
        return this.deletedFiles;
    }

    public List<DataFileMeta> changelogFiles() {
        return this.changelogFiles;
    }

    public boolean isEmpty() {
        return this.newFiles.isEmpty() && this.changelogFiles.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataIncrement that = (DataIncrement)o;
        return Objects.equals(this.newFiles, that.newFiles) && Objects.equals(this.changelogFiles, that.changelogFiles);
    }

    public int hashCode() {
        return Objects.hash(this.newFiles, this.changelogFiles);
    }

    public String toString() {
        return String.format("DataIncrement {newFiles = %s, deletedFiles = %s, changelogFiles = %s}", this.newFiles.stream().map(DataFileMeta::fileName).collect(Collectors.toList()), this.deletedFiles.stream().map(DataFileMeta::fileName).collect(Collectors.toList()), this.changelogFiles.stream().map(DataFileMeta::fileName).collect(Collectors.toList()));
    }
}

