/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.lookup.sort;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.paimon.lookup.sort.BlockHandle;
import org.apache.paimon.lookup.sort.BloomFilterHandle;
import org.apache.paimon.memory.MemorySlice;
import org.apache.paimon.memory.MemorySliceInput;
import org.apache.paimon.memory.MemorySliceOutput;
import org.apache.paimon.utils.Preconditions;

public class Footer {
    public static final int ENCODED_LENGTH = 36;
    @Nullable
    private final BloomFilterHandle bloomFilterHandle;
    private final BlockHandle indexBlockHandle;

    Footer(@Nullable BloomFilterHandle bloomFilterHandle, BlockHandle indexBlockHandle) {
        this.bloomFilterHandle = bloomFilterHandle;
        this.indexBlockHandle = indexBlockHandle;
    }

    @Nullable
    public BloomFilterHandle getBloomFilterHandle() {
        return this.bloomFilterHandle;
    }

    public BlockHandle getIndexBlockHandle() {
        return this.indexBlockHandle;
    }

    public static Footer readFooter(MemorySliceInput sliceInput) throws IOException {
        BloomFilterHandle bloomFilterHandle = new BloomFilterHandle(sliceInput.readLong(), sliceInput.readInt(), sliceInput.readLong());
        if (bloomFilterHandle.offset() == 0L && bloomFilterHandle.size() == 0 && bloomFilterHandle.expectedEntries() == 0L) {
            bloomFilterHandle = null;
        }
        BlockHandle indexBlockHandle = new BlockHandle(sliceInput.readLong(), sliceInput.readInt());
        sliceInput.setPosition(32);
        int magicNumber = sliceInput.readInt();
        Preconditions.checkArgument(magicNumber == 1481571681, "File is not a table (bad magic number)");
        return new Footer(bloomFilterHandle, indexBlockHandle);
    }

    public static MemorySlice writeFooter(Footer footer) {
        MemorySliceOutput output = new MemorySliceOutput(36);
        Footer.writeFooter(footer, output);
        return output.toSlice();
    }

    public static void writeFooter(Footer footer, MemorySliceOutput sliceOutput) {
        if (footer.bloomFilterHandle == null) {
            sliceOutput.writeLong(0L);
            sliceOutput.writeInt(0);
            sliceOutput.writeLong(0L);
        } else {
            sliceOutput.writeLong(footer.bloomFilterHandle.offset());
            sliceOutput.writeInt(footer.bloomFilterHandle.size());
            sliceOutput.writeLong(footer.bloomFilterHandle.expectedEntries());
        }
        sliceOutput.writeLong(footer.indexBlockHandle.offset());
        sliceOutput.writeInt(footer.indexBlockHandle.size());
        sliceOutput.writeInt(1481571681);
    }
}

