/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.utils.ExceptionUtils;

public class LoserTree<T>
implements Closeable {
    private final int[] tree;
    private final int size;
    private final List<LeafIterator<T>> leaves;
    private final Comparator<T> firstComparator;
    private final Comparator<T> secondComparator;
    private boolean initialized;

    public LoserTree(List<RecordReader<T>> nextBatchReaders, Comparator<T> firstComparator, Comparator<T> secondComparator) {
        this.size = nextBatchReaders.size();
        this.leaves = new ArrayList<LeafIterator<T>>(this.size);
        this.tree = new int[this.size];
        this.firstComparator = (e1, e2) -> e1 == null ? -1 : (e2 == null ? 1 : firstComparator.compare(e1, e2));
        this.secondComparator = (e1, e2) -> e1 == null ? -1 : (e2 == null ? 1 : secondComparator.compare(e1, e2));
        this.initialized = false;
        for (RecordReader<T> reader : nextBatchReaders) {
            LeafIterator iterator2 = new LeafIterator(reader);
            this.leaves.add(iterator2);
        }
    }

    public void initializeIfNeeded() throws IOException {
        if (!this.initialized) {
            Arrays.fill(this.tree, -1);
            for (int i = this.size - 1; i >= 0; --i) {
                this.leaves.get(i).advanceIfAvailable();
                this.adjust(i);
            }
            this.initialized = true;
        }
    }

    public void adjustForNextLoop() throws IOException {
        LeafIterator<T> winner = this.leaves.get(this.tree[0]);
        while (((LeafIterator)winner).state == State.WINNER_POPPED) {
            winner.advanceIfAvailable();
            this.adjust(this.tree[0]);
            winner = this.leaves.get(this.tree[0]);
        }
    }

    public T popWinner() {
        LeafIterator<T> winner = this.leaves.get(this.tree[0]);
        if (((LeafIterator)winner).state == State.WINNER_POPPED) {
            return null;
        }
        T result = winner.pop();
        this.adjust(this.tree[0]);
        return result;
    }

    public T peekWinner() {
        return ((LeafIterator)this.leaves.get(this.tree[0])).state != State.WINNER_POPPED ? (T)this.leaves.get(this.tree[0]).peek() : null;
    }

    private void adjust(int winner) {
        for (int parent = (winner + this.size) / 2; parent > 0 && winner >= 0; parent /= 2) {
            LeafIterator<T> winnerNode = this.leaves.get(winner);
            if (this.tree[parent] == -1) {
                ((LeafIterator)winnerNode).state = State.LOSER_WITH_NEW_KEY;
            } else {
                LeafIterator<T> parentNode = this.leaves.get(this.tree[parent]);
                switch (((LeafIterator)winnerNode).state) {
                    case WINNER_WITH_NEW_KEY: {
                        this.adjustWithNewWinnerKey(parent, parentNode, winnerNode);
                        break;
                    }
                    case WINNER_WITH_SAME_KEY: {
                        this.adjustWithSameWinnerKey(parent, parentNode, winnerNode);
                        break;
                    }
                    case WINNER_POPPED: {
                        if (((LeafIterator)winnerNode).firstSameKeyIndex < 0) {
                            parent = -1;
                            break;
                        }
                        parent = ((LeafIterator)winnerNode).firstSameKeyIndex;
                        parentNode = this.leaves.get(this.tree[parent]);
                        ((LeafIterator)winnerNode).state = State.LOSER_POPPED;
                        ((LeafIterator)parentNode).state = State.WINNER_WITH_SAME_KEY;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unknown state for " + ((LeafIterator)winnerNode).state.name());
                    }
                }
            }
            if (((LeafIterator)winnerNode).state.isWinner()) continue;
            int tmp = winner;
            winner = this.tree[parent];
            this.tree[parent] = tmp;
        }
        this.tree[0] = winner;
    }

    private void adjustWithSameWinnerKey(int index, LeafIterator<T> parentNode, LeafIterator<T> winnerNode) {
        switch (((LeafIterator)parentNode).state) {
            case LOSER_WITH_SAME_KEY: {
                T parentKey = parentNode.peek();
                T childKey = winnerNode.peek();
                int secondResult = this.secondComparator.compare(parentKey, childKey);
                if (secondResult > 0) {
                    ((LeafIterator)parentNode).state = State.WINNER_WITH_SAME_KEY;
                    ((LeafIterator)winnerNode).state = State.LOSER_WITH_SAME_KEY;
                    parentNode.setFirstSameKeyIndex(index);
                } else {
                    winnerNode.setFirstSameKeyIndex(index);
                }
                return;
            }
            case LOSER_WITH_NEW_KEY: 
            case LOSER_POPPED: {
                return;
            }
        }
        throw new UnsupportedOperationException("unknown state for " + ((LeafIterator)parentNode).state.name());
    }

    private void adjustWithNewWinnerKey(int index, LeafIterator<T> parentNode, LeafIterator<T> winnerNode) {
        switch (((LeafIterator)parentNode).state) {
            case LOSER_WITH_NEW_KEY: {
                T parentKey = parentNode.peek();
                T childKey = winnerNode.peek();
                int firstResult = this.firstComparator.compare(parentKey, childKey);
                if (firstResult == 0) {
                    int secondResult = this.secondComparator.compare(parentKey, childKey);
                    if (secondResult < 0) {
                        ((LeafIterator)parentNode).state = State.LOSER_WITH_SAME_KEY;
                        winnerNode.setFirstSameKeyIndex(index);
                    } else {
                        ((LeafIterator)winnerNode).state = State.LOSER_WITH_SAME_KEY;
                        ((LeafIterator)parentNode).state = State.WINNER_WITH_NEW_KEY;
                        parentNode.setFirstSameKeyIndex(index);
                    }
                } else if (firstResult > 0) {
                    ((LeafIterator)parentNode).state = State.WINNER_WITH_NEW_KEY;
                    ((LeafIterator)winnerNode).state = State.LOSER_WITH_NEW_KEY;
                }
                return;
            }
            case LOSER_WITH_SAME_KEY: {
                throw new RuntimeException("This is a bug. Please file an issue. A node in the WINNER_WITH_NEW_KEY state cannot encounter a node in the LOSER_WITH_SAME_KEY state.");
            }
            case LOSER_POPPED: {
                ((LeafIterator)parentNode).state = State.WINNER_POPPED;
                ((LeafIterator)parentNode).firstSameKeyIndex = -1;
                ((LeafIterator)winnerNode).state = State.LOSER_WITH_NEW_KEY;
                return;
            }
        }
        throw new UnsupportedOperationException("unknown state for " + ((LeafIterator)parentNode).state.name());
    }

    @Override
    public void close() throws IOException {
        IOException exception = null;
        for (LeafIterator<T> iterator2 : this.leaves) {
            try {
                iterator2.close();
            }
            catch (IOException e) {
                exception = ExceptionUtils.firstOrSuppressed(e, exception);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static enum State {
        LOSER_WITH_NEW_KEY(false),
        LOSER_WITH_SAME_KEY(false),
        LOSER_POPPED(false),
        WINNER_WITH_NEW_KEY(true),
        WINNER_WITH_SAME_KEY(true),
        WINNER_POPPED(true);

        private final boolean winner;

        private State(boolean winner) {
            this.winner = winner;
        }

        public boolean isWinner() {
            return this.winner;
        }
    }

    private static class LeafIterator<T>
    implements Closeable {
        private final RecordReader<T> reader;
        private RecordReader.RecordIterator<T> iterator;
        private T kv;
        private boolean endOfInput;
        private int firstSameKeyIndex;
        private State state;

        private LeafIterator(RecordReader<T> reader) {
            this.reader = reader;
            this.endOfInput = false;
            this.firstSameKeyIndex = -1;
            this.state = State.WINNER_WITH_NEW_KEY;
        }

        public T peek() {
            return this.kv;
        }

        public T pop() {
            this.state = State.WINNER_POPPED;
            return this.kv;
        }

        public void setFirstSameKeyIndex(int index) {
            if (this.firstSameKeyIndex == -1) {
                this.firstSameKeyIndex = index;
            }
        }

        public void advanceIfAvailable() throws IOException {
            this.firstSameKeyIndex = -1;
            this.state = State.WINNER_WITH_NEW_KEY;
            if (this.iterator == null || (this.kv = this.iterator.next()) == null) {
                while (!this.endOfInput) {
                    if (this.iterator != null) {
                        this.iterator.releaseBatch();
                        this.iterator = null;
                    }
                    this.iterator = this.reader.readBatch();
                    if (this.iterator == null) {
                        this.endOfInput = true;
                        this.kv = null;
                        this.reader.close();
                        continue;
                    }
                    this.kv = this.iterator.next();
                    if (this.kv == null) continue;
                    break;
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.iterator != null) {
                this.iterator.releaseBatch();
                this.iterator = null;
            }
            this.reader.close();
        }
    }
}

