/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.orc.impl;

import com.github.luben.zstd.util.Native;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.paimon.shade.com.google.protobuf.ByteString;
import org.apache.paimon.shade.io.airlift.compress.lz4.Lz4Compressor;
import org.apache.paimon.shade.io.airlift.compress.lz4.Lz4Decompressor;
import org.apache.paimon.shade.io.airlift.compress.lzo.LzoCompressor;
import org.apache.paimon.shade.io.airlift.compress.lzo.LzoDecompressor;
import org.apache.paimon.shade.io.airlift.compress.zstd.ZstdCompressor;
import org.apache.paimon.shade.io.airlift.compress.zstd.ZstdDecompressor;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.orc.ColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.CompressionCodec;
import org.apache.paimon.shade.org.apache.orc.CompressionKind;
import org.apache.paimon.shade.org.apache.orc.DataMask;
import org.apache.paimon.shade.org.apache.orc.MemoryManager;
import org.apache.paimon.shade.org.apache.orc.OrcConf;
import org.apache.paimon.shade.org.apache.orc.OrcFile;
import org.apache.paimon.shade.org.apache.orc.OrcProto;
import org.apache.paimon.shade.org.apache.orc.OrcUtils;
import org.apache.paimon.shade.org.apache.orc.PhysicalWriter;
import org.apache.paimon.shade.org.apache.orc.StripeInformation;
import org.apache.paimon.shade.org.apache.orc.StripeStatistics;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.shade.org.apache.orc.impl.AircompressorCodec;
import org.apache.paimon.shade.org.apache.orc.impl.CryptoUtils;
import org.apache.paimon.shade.org.apache.orc.impl.HadoopShims;
import org.apache.paimon.shade.org.apache.orc.impl.KeyProvider;
import org.apache.paimon.shade.org.apache.orc.impl.MaskDescriptionImpl;
import org.apache.paimon.shade.org.apache.orc.impl.OutStream;
import org.apache.paimon.shade.org.apache.orc.impl.ParserUtils;
import org.apache.paimon.shade.org.apache.orc.impl.PhysicalFsWriter;
import org.apache.paimon.shade.org.apache.orc.impl.SerializationUtils;
import org.apache.paimon.shade.org.apache.orc.impl.SnappyCodec;
import org.apache.paimon.shade.org.apache.orc.impl.StreamName;
import org.apache.paimon.shade.org.apache.orc.impl.StripeStatisticsImpl;
import org.apache.paimon.shade.org.apache.orc.impl.WriterInternal;
import org.apache.paimon.shade.org.apache.orc.impl.ZlibCodec;
import org.apache.paimon.shade.org.apache.orc.impl.ZstdCodec;
import org.apache.paimon.shade.org.apache.orc.impl.writer.StreamOptions;
import org.apache.paimon.shade.org.apache.orc.impl.writer.TreeWriter;
import org.apache.paimon.shade.org.apache.orc.impl.writer.WriterContext;
import org.apache.paimon.shade.org.apache.orc.impl.writer.WriterEncryptionKey;
import org.apache.paimon.shade.org.apache.orc.impl.writer.WriterEncryptionVariant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterImpl
implements WriterInternal,
MemoryManager.Callback {
    private static final Logger LOG = LoggerFactory.getLogger(WriterImpl.class);
    private static final int MIN_ROW_INDEX_STRIDE = 1000;
    private final Path path;
    private final long stripeSize;
    private final long stripeRowCount;
    private final int rowIndexStride;
    private final TypeDescription schema;
    private final PhysicalWriter physicalWriter;
    private final OrcFile.WriterVersion writerVersion;
    private final StreamOptions unencryptedOptions;
    private long rowCount = 0L;
    private long rowsInStripe = 0L;
    private long rawDataSize = 0L;
    private int rowsInIndex = 0;
    private long lastFlushOffset = 0L;
    private int stripesAtLastFlush = -1;
    private final List<OrcProto.StripeInformation> stripes = new ArrayList<OrcProto.StripeInformation>();
    private final Map<String, ByteString> userMetadata = new TreeMap<String, ByteString>();
    private final TreeWriter treeWriter;
    private final boolean buildIndex;
    private final MemoryManager memoryManager;
    private long previousAllocation = -1L;
    private long memoryLimit;
    private final long rowsPerCheck;
    private long rowsSinceCheck = 0L;
    private final OrcFile.Version version;
    private final Configuration conf;
    private final OrcFile.WriterCallback callback;
    private final OrcFile.WriterContext callbackContext;
    private final OrcFile.EncodingStrategy encodingStrategy;
    private final OrcFile.CompressionStrategy compressionStrategy;
    private final boolean[] bloomFilterColumns;
    private final double bloomFilterFpp;
    private final OrcFile.BloomFilterVersion bloomFilterVersion;
    private final boolean writeTimeZone;
    private final boolean useUTCTimeZone;
    private final double dictionaryKeySizeThreshold;
    private final boolean[] directEncodingColumns;
    private final List<OrcProto.ColumnEncoding> unencryptedEncodings = new ArrayList<OrcProto.ColumnEncoding>();
    private SortedMap<String, MaskDescriptionImpl> maskDescriptions = new TreeMap<String, MaskDescriptionImpl>();
    private SortedMap<String, WriterEncryptionKey> keys = new TreeMap<String, WriterEncryptionKey>();
    private final WriterEncryptionVariant[] encryption;
    private final MaskDescriptionImpl[] columnMaskDescriptions;
    private final WriterEncryptionVariant[] columnEncryption;
    private KeyProvider keyProvider;
    private boolean needKeyFlush;
    private final boolean useProlepticGregorian;
    private boolean isClose = false;

    public WriterImpl(FileSystem fs, Path path, OrcFile.WriterOptions opts) throws IOException {
        this.path = path;
        this.conf = opts.getConfiguration();
        this.schema = opts.getSchema().clone();
        int numColumns = this.schema.getMaximumId() + 1;
        if (!opts.isEnforceBufferSize()) {
            opts.bufferSize(WriterImpl.getEstimatedBufferSize(opts.getStripeSize(), numColumns, opts.getBufferSize()));
        }
        this.schema.annotateEncryption(opts.getEncryption(), opts.getMasks());
        this.columnEncryption = new WriterEncryptionVariant[numColumns];
        this.columnMaskDescriptions = new MaskDescriptionImpl[numColumns];
        this.encryption = this.setupEncryption(opts.getKeyProvider(), this.schema, opts.getKeyOverrides());
        this.needKeyFlush = this.encryption.length > 0;
        this.directEncodingColumns = OrcUtils.includeColumns(opts.getDirectEncodingColumns(), opts.getSchema());
        this.dictionaryKeySizeThreshold = OrcConf.DICTIONARY_KEY_SIZE_THRESHOLD.getDouble(this.conf);
        this.callback = opts.getCallback();
        this.callbackContext = this.callback != null ? () -> this : null;
        this.useProlepticGregorian = opts.getProlepticGregorian();
        this.writeTimeZone = WriterImpl.hasTimestamp(this.schema);
        this.useUTCTimeZone = opts.getUseUTCTimestamp();
        this.encodingStrategy = opts.getEncodingStrategy();
        this.compressionStrategy = opts.getCompressionStrategy();
        this.rowIndexStride = opts.getRowIndexStride() >= 0 ? opts.getRowIndexStride() : 0;
        boolean bl = this.buildIndex = this.rowIndexStride > 0;
        if (this.buildIndex && this.rowIndexStride < 1000) {
            throw new IllegalArgumentException("Row stride must be at least 1000");
        }
        this.writerVersion = opts.getWriterVersion();
        this.version = opts.getVersion();
        if (this.version == OrcFile.Version.FUTURE) {
            throw new IllegalArgumentException("Can not write in a unknown version.");
        }
        if (this.version == OrcFile.Version.UNSTABLE_PRE_2_0) {
            LOG.warn("ORC files written in " + this.version.getName() + " will not be readable by other versions of the software. It is only for developer testing.");
        }
        this.bloomFilterVersion = opts.getBloomFilterVersion();
        this.bloomFilterFpp = opts.getBloomFilterFpp();
        this.bloomFilterColumns = !this.buildIndex || this.version == OrcFile.Version.V_0_11 ? new boolean[this.schema.getMaximumId() + 1] : OrcUtils.includeColumns(opts.getBloomFilterColumns(), this.schema);
        this.rowsPerCheck = Math.min(opts.getStripeRowCountValue(), OrcConf.ROWS_BETWEEN_CHECKS.getLong(this.conf));
        this.stripeRowCount = opts.getStripeRowCountValue();
        this.memoryLimit = this.stripeSize = opts.getStripeSize();
        this.memoryManager = opts.getMemoryManager();
        this.memoryManager.addWriter(path, this.stripeSize, this);
        this.physicalWriter = opts.getPhysicalWriter() == null ? new PhysicalFsWriter(fs, path, opts, this.encryption) : opts.getPhysicalWriter();
        this.physicalWriter.writeHeader();
        this.unencryptedOptions = this.physicalWriter.getStreamOptions();
        OutStream.assertBufferSizeValid(this.unencryptedOptions.getBufferSize());
        this.treeWriter = TreeWriter.Factory.create(this.schema, null, new StreamFactory());
        LOG.info("ORC writer created for path: {} with stripeSize: {} options: {}", new Object[]{path, this.stripeSize, this.unencryptedOptions});
    }

    public static int getEstimatedBufferSize(long stripeSize, int numColumns, int bs) {
        int estBufferSize = (int)(stripeSize / (20L * (long)numColumns));
        estBufferSize = WriterImpl.getClosestBufferSize(estBufferSize);
        return Math.min(estBufferSize, bs);
    }

    @Override
    public void increaseCompressionSize(int newSize) {
        if (newSize > this.unencryptedOptions.getBufferSize()) {
            this.unencryptedOptions.bufferSize(newSize);
        }
    }

    private static int getClosestBufferSize(int size) {
        int kb4 = 4096;
        int kb256 = 262144;
        int pow2 = size == 1 ? 1 : Integer.highestOneBit(size - 1) * 2;
        return Math.min(262144, Math.max(4096, pow2));
    }

    public static CompressionCodec createCodec(CompressionKind kind) {
        switch (kind) {
            case NONE: {
                return null;
            }
            case ZLIB: {
                return new ZlibCodec();
            }
            case SNAPPY: {
                return new SnappyCodec();
            }
            case LZO: {
                return new AircompressorCodec(kind, new LzoCompressor(), new LzoDecompressor());
            }
            case LZ4: {
                return new AircompressorCodec(kind, new Lz4Compressor(), new Lz4Decompressor());
            }
            case ZSTD: {
                if ("java".equalsIgnoreCase(System.getProperty("orc.compression.zstd.impl"))) {
                    return new AircompressorCodec(kind, new ZstdCompressor(), new ZstdDecompressor());
                }
                if (Native.isLoaded()) {
                    return new ZstdCodec();
                }
                return new AircompressorCodec(kind, new ZstdCompressor(), new ZstdDecompressor());
            }
        }
        throw new IllegalArgumentException("Unknown compression codec: " + (Object)((Object)kind));
    }

    @Override
    public boolean checkMemory(double newScale) throws IOException {
        this.memoryLimit = Math.round((double)this.stripeSize * newScale);
        return this.checkMemory();
    }

    private boolean checkMemory() throws IOException {
        if (this.rowsSinceCheck >= this.rowsPerCheck) {
            this.rowsSinceCheck = 0L;
            long size = this.treeWriter.estimateMemory();
            if (LOG.isDebugEnabled()) {
                LOG.debug("ORC writer " + this.physicalWriter + " size = " + size + " memoryLimit = " + this.memoryLimit + " rowsInStripe = " + this.rowsInStripe + " stripeRowCountLimit = " + this.stripeRowCount);
            }
            if (size > this.memoryLimit || this.rowsInStripe >= this.stripeRowCount) {
                this.flushStripe();
                return true;
            }
        }
        return false;
    }

    private static void writeTypes(OrcProto.Footer.Builder builder, TypeDescription schema) {
        builder.addAllTypes(OrcUtils.getOrcTypes(schema));
    }

    private void createRowIndexEntry() throws IOException {
        this.treeWriter.createRowIndexEntry();
        this.rowsInIndex = 0;
    }

    private void addEncryptedKeys(OrcProto.StripeInformation.Builder dirEntry) {
        for (WriterEncryptionVariant variant : this.encryption) {
            dirEntry.addEncryptedLocalKeys(ByteString.copyFrom(variant.getMaterial().getEncryptedKey()));
        }
        dirEntry.setEncryptStripeId(1 + this.stripes.size());
    }

    private void flushStripe() throws IOException {
        if (this.buildIndex && this.rowsInIndex != 0) {
            this.createRowIndexEntry();
        }
        if (this.rowsInStripe != 0L) {
            if (this.callback != null) {
                this.callback.preStripeWrite(this.callbackContext);
            }
            int requiredIndexEntries = this.rowIndexStride == 0 ? 0 : (int)((this.rowsInStripe + (long)this.rowIndexStride - 1L) / (long)this.rowIndexStride);
            OrcProto.StripeFooter.Builder builder = OrcProto.StripeFooter.newBuilder();
            if (this.writeTimeZone) {
                if (this.useUTCTimeZone) {
                    builder.setWriterTimezone("UTC");
                } else {
                    builder.setWriterTimezone(TimeZone.getDefault().getID());
                }
            }
            this.treeWriter.flushStreams();
            this.treeWriter.writeStripe(requiredIndexEntries);
            builder.addAllColumns(this.unencryptedEncodings);
            this.unencryptedEncodings.clear();
            for (WriterEncryptionVariant writerEncryptionVariant : this.encryption) {
                OrcProto.StripeEncryptionVariant.Builder encrypt = OrcProto.StripeEncryptionVariant.newBuilder();
                encrypt.addAllEncoding(writerEncryptionVariant.getEncodings());
                writerEncryptionVariant.clearEncodings();
                builder.addEncryption(encrypt);
            }
            OrcProto.StripeInformation.Builder dirEntry = OrcProto.StripeInformation.newBuilder().setNumberOfRows(this.rowsInStripe);
            if (this.encryption.length > 0 && this.needKeyFlush) {
                this.addEncryptedKeys(dirEntry);
                this.needKeyFlush = false;
            }
            this.physicalWriter.finalizeStripe(builder, dirEntry);
            this.stripes.add(dirEntry.build());
            this.rowCount += this.rowsInStripe;
            this.rowsInStripe = 0L;
        }
    }

    private long computeRawDataSize() {
        return this.treeWriter.getRawDataSize();
    }

    private OrcProto.CompressionKind writeCompressionKind(CompressionKind kind) {
        switch (kind) {
            case NONE: {
                return OrcProto.CompressionKind.NONE;
            }
            case ZLIB: {
                return OrcProto.CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return OrcProto.CompressionKind.SNAPPY;
            }
            case LZO: {
                return OrcProto.CompressionKind.LZO;
            }
            case LZ4: {
                return OrcProto.CompressionKind.LZ4;
            }
            case ZSTD: {
                return OrcProto.CompressionKind.ZSTD;
            }
        }
        throw new IllegalArgumentException("Unknown compression " + (Object)((Object)kind));
    }

    private void writeMetadata() throws IOException {
        this.physicalWriter.writeFileMetadata(OrcProto.Metadata.newBuilder());
    }

    private long writePostScript() throws IOException {
        OrcProto.PostScript.Builder builder = OrcProto.PostScript.newBuilder().setMagic("ORC").addVersion(this.version.getMajor()).addVersion(this.version.getMinor()).setWriterVersion(this.writerVersion.getId());
        CompressionCodec codec = this.unencryptedOptions.getCodec();
        if (codec == null) {
            builder.setCompression(OrcProto.CompressionKind.NONE);
        } else {
            builder.setCompression(this.writeCompressionKind(codec.getKind())).setCompressionBlockSize(this.unencryptedOptions.getBufferSize());
        }
        return this.physicalWriter.writePostScript(builder);
    }

    private OrcProto.EncryptionKey.Builder writeEncryptionKey(WriterEncryptionKey key) {
        OrcProto.EncryptionKey.Builder result = OrcProto.EncryptionKey.newBuilder();
        HadoopShims.KeyMetadata meta = key.getMetadata();
        result.setKeyName(meta.getKeyName());
        result.setKeyVersion(meta.getVersion());
        result.setAlgorithm(OrcProto.EncryptionAlgorithm.valueOf(meta.getAlgorithm().getSerialization()));
        return result;
    }

    private OrcProto.EncryptionVariant.Builder writeEncryptionVariant(WriterEncryptionVariant variant) {
        OrcProto.EncryptionVariant.Builder result = OrcProto.EncryptionVariant.newBuilder();
        result.setRoot(variant.getRoot().getId());
        result.setKey(variant.getKeyDescription().getId());
        result.setEncryptedKey(ByteString.copyFrom(variant.getMaterial().getEncryptedKey()));
        return result;
    }

    private OrcProto.Encryption.Builder writeEncryptionFooter() {
        OrcProto.Encryption.Builder encrypt = OrcProto.Encryption.newBuilder();
        for (MaskDescriptionImpl mask : this.maskDescriptions.values()) {
            OrcProto.DataMask.Builder maskBuilder = OrcProto.DataMask.newBuilder();
            maskBuilder.setName(mask.getName());
            for (String param : mask.getParameters()) {
                maskBuilder.addMaskParameters(param);
            }
            for (TypeDescription column : mask.getColumns()) {
                maskBuilder.addColumns(column.getId());
            }
            encrypt.addMask(maskBuilder);
        }
        for (WriterEncryptionKey key : this.keys.values()) {
            encrypt.addKey(this.writeEncryptionKey(key));
        }
        for (Iterator<Comparable<MaskDescriptionImpl>> iterator2 : this.encryption) {
            encrypt.addVariants(this.writeEncryptionVariant((WriterEncryptionVariant)((Object)iterator2)));
        }
        encrypt.setKeyProvider(OrcProto.KeyProviderKind.valueOf(this.keyProvider.getKind().getValue()));
        return encrypt;
    }

    private long writeFooter() throws IOException {
        this.writeMetadata();
        OrcProto.Footer.Builder builder = OrcProto.Footer.newBuilder();
        builder.setNumberOfRows(this.rowCount);
        builder.setRowIndexStride(this.rowIndexStride);
        this.rawDataSize = this.computeRawDataSize();
        WriterImpl.writeTypes(builder, this.schema);
        builder.setCalendar(this.useProlepticGregorian ? OrcProto.CalendarKind.PROLEPTIC_GREGORIAN : OrcProto.CalendarKind.JULIAN_GREGORIAN);
        for (OrcProto.StripeInformation stripeInformation : this.stripes) {
            builder.addStripes(stripeInformation);
        }
        this.treeWriter.writeFileStatistics();
        for (Map.Entry entry : this.userMetadata.entrySet()) {
            builder.addMetadata(OrcProto.UserMetadataItem.newBuilder().setName((String)entry.getKey()).setValue((ByteString)entry.getValue()));
        }
        if (this.encryption.length > 0) {
            builder.setEncryption(this.writeEncryptionFooter());
        }
        builder.setWriter(OrcFile.WriterImplementation.ORC_JAVA.getId());
        builder.setSoftwareVersion(OrcUtils.getOrcVersion());
        this.physicalWriter.writeFileFooter(builder);
        return this.writePostScript();
    }

    @Override
    public TypeDescription getSchema() {
        return this.schema;
    }

    @Override
    public void addUserMetadata(String name, ByteBuffer value) {
        this.userMetadata.put(name, ByteString.copyFrom(value));
    }

    @Override
    public void addRowBatch(VectorizedRowBatch batch) throws IOException {
        try {
            if (batch.size != 0 && this.rowsInStripe == 0L) {
                this.treeWriter.prepareStripe(this.stripes.size() + 1);
            }
            if (this.buildIndex) {
                int posn = 0;
                while (posn < batch.size) {
                    int chunkSize = Math.min(batch.size - posn, this.rowIndexStride - this.rowsInIndex);
                    if (batch.isSelectedInUse()) {
                        for (int len = 1; len < chunkSize; ++len) {
                            if (batch.selected[posn + len] - batch.selected[posn] == len) continue;
                            chunkSize = len;
                            break;
                        }
                        this.treeWriter.writeRootBatch(batch, batch.selected[posn], chunkSize);
                    } else {
                        this.treeWriter.writeRootBatch(batch, posn, chunkSize);
                    }
                    posn += chunkSize;
                    this.rowsInIndex += chunkSize;
                    this.rowsInStripe += (long)chunkSize;
                    if (this.rowsInIndex < this.rowIndexStride) continue;
                    this.createRowIndexEntry();
                }
            } else {
                if (batch.isSelectedInUse()) {
                    int chunkSize;
                    for (int posn = 0; posn < batch.size; posn += chunkSize) {
                        for (chunkSize = 1; posn + chunkSize < batch.size && batch.selected[posn + chunkSize] - batch.selected[posn] == chunkSize; ++chunkSize) {
                        }
                        this.treeWriter.writeRootBatch(batch, batch.selected[posn], chunkSize);
                    }
                } else {
                    this.treeWriter.writeRootBatch(batch, 0, batch.size);
                }
                this.rowsInStripe += (long)batch.size;
            }
            this.rowsSinceCheck += (long)batch.size;
            this.previousAllocation = this.memoryManager.checkMemory(this.previousAllocation, this);
            this.checkMemory();
        }
        catch (Throwable t) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Problem adding row to " + this.path, t);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClose) {
            try {
                if (this.callback != null) {
                    this.callback.preFooterWrite(this.callbackContext);
                }
                this.memoryManager.removeWriter(this.path);
                this.flushStripe();
                this.lastFlushOffset = this.writeFooter();
                this.physicalWriter.close();
            }
            finally {
                this.isClose = true;
            }
        }
    }

    @Override
    public long getRawDataSize() {
        return this.rawDataSize;
    }

    @Override
    public long getNumberOfRows() {
        return this.rowCount;
    }

    @Override
    public long writeIntermediateFooter() throws IOException {
        this.flushStripe();
        if (this.stripesAtLastFlush != this.stripes.size()) {
            if (this.callback != null) {
                this.callback.preFooterWrite(this.callbackContext);
            }
            this.lastFlushOffset = this.writeFooter();
            this.stripesAtLastFlush = this.stripes.size();
            this.physicalWriter.flush();
        }
        return this.lastFlushOffset;
    }

    private static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void appendStripe(byte[] stripe, int offset, int length, StripeInformation stripeInfo, OrcProto.StripeStatistics stripeStatistics) throws IOException {
        this.appendStripe(stripe, offset, length, stripeInfo, new StripeStatistics[]{new StripeStatisticsImpl(this.schema, stripeStatistics.getColStatsList(), false, false)});
    }

    @Override
    public void appendStripe(byte[] stripe, int offset, int length, StripeInformation stripeInfo, StripeStatistics[] stripeStatistics) throws IOException {
        WriterImpl.checkArgument(stripe != null, "Stripe must not be null");
        WriterImpl.checkArgument(length <= stripe.length, "Specified length must not be greater specified array length");
        WriterImpl.checkArgument(stripeInfo != null, "Stripe information must not be null");
        WriterImpl.checkArgument(stripeStatistics != null, "Stripe statistics must not be null");
        if (this.rowsInStripe > 0L) {
            this.flushStripe();
        }
        this.rowsInStripe = stripeInfo.getNumberOfRows();
        OrcProto.StripeInformation.Builder dirEntry = OrcProto.StripeInformation.newBuilder().setNumberOfRows(this.rowsInStripe).setIndexLength(stripeInfo.getIndexLength()).setDataLength(stripeInfo.getDataLength()).setFooterLength(stripeInfo.getFooterLength());
        if (stripeInfo.hasEncryptionStripeId()) {
            dirEntry.setEncryptStripeId(stripeInfo.getEncryptionStripeId());
            for (byte[] key : stripeInfo.getEncryptedLocalKeys()) {
                dirEntry.addEncryptedLocalKeys(ByteString.copyFrom(key));
            }
        }
        this.physicalWriter.appendRawStripe(ByteBuffer.wrap(stripe, offset, length), dirEntry);
        this.treeWriter.addStripeStatistics(stripeStatistics);
        this.stripes.add(dirEntry.build());
        this.rowCount += this.rowsInStripe;
        this.rowsInStripe = 0L;
        this.needKeyFlush = this.encryption.length > 0;
    }

    @Override
    public void appendUserMetadata(List<OrcProto.UserMetadataItem> userMetadata) {
        if (userMetadata != null) {
            for (OrcProto.UserMetadataItem item : userMetadata) {
                this.userMetadata.put(item.getName(), item.getValue());
            }
        }
    }

    @Override
    public ColumnStatistics[] getStatistics() {
        ColumnStatistics[] result = new ColumnStatistics[this.schema.getMaximumId() + 1];
        this.treeWriter.getCurrentStatistics(result);
        return result;
    }

    @Override
    public List<StripeInformation> getStripes() throws IOException {
        return Collections.unmodifiableList(OrcUtils.convertProtoStripesToStripes(this.stripes));
    }

    public CompressionCodec getCompressionCodec() {
        return this.unencryptedOptions.getCodec();
    }

    private static boolean hasTimestamp(TypeDescription schema) {
        if (schema.getCategory() == TypeDescription.Category.TIMESTAMP) {
            return true;
        }
        List<TypeDescription> children = schema.getChildren();
        if (children != null) {
            for (TypeDescription child : children) {
                if (!WriterImpl.hasTimestamp(child)) continue;
                return true;
            }
        }
        return false;
    }

    private WriterEncryptionKey getKey(String keyName, KeyProvider provider) throws IOException {
        WriterEncryptionKey result = (WriterEncryptionKey)this.keys.get(keyName);
        if (result == null) {
            result = new WriterEncryptionKey(provider.getCurrentKeyVersion(keyName));
            this.keys.put(keyName, result);
        }
        return result;
    }

    private MaskDescriptionImpl getMask(String maskString) {
        MaskDescriptionImpl result = (MaskDescriptionImpl)this.maskDescriptions.get(maskString);
        if (result == null) {
            result = ParserUtils.buildMaskDescription(maskString);
            this.maskDescriptions.put(maskString, result);
        }
        return result;
    }

    private int visitTypeTree(TypeDescription schema, boolean encrypted, KeyProvider provider) throws IOException {
        List<TypeDescription> children;
        int result = 0;
        String keyName = schema.getAttributeValue("encrypt");
        String maskName = schema.getAttributeValue("mask");
        if (keyName != null) {
            if (provider == null) {
                throw new IllegalArgumentException("Encryption requires a KeyProvider.");
            }
            if (encrypted) {
                throw new IllegalArgumentException("Nested encryption type: " + schema);
            }
            encrypted = true;
            ++result;
            WriterEncryptionKey key = this.getKey(keyName, provider);
            HadoopShims.KeyMetadata metadata = key.getMetadata();
            WriterEncryptionVariant variant = new WriterEncryptionVariant(key, schema, provider.createLocalKey(metadata));
            key.addRoot(variant);
        }
        if (encrypted && (keyName != null || maskName != null)) {
            MaskDescriptionImpl mask = this.getMask(maskName == null ? "nullify" : maskName);
            mask.addColumn(schema);
        }
        if ((children = schema.getChildren()) != null) {
            for (TypeDescription child : children) {
                result += this.visitTypeTree(child, encrypted, provider);
            }
        }
        return result;
    }

    private WriterEncryptionVariant[] setupEncryption(KeyProvider provider, TypeDescription schema, Map<String, HadoopShims.KeyMetadata> keyOverrides) throws IOException {
        this.keyProvider = provider != null ? provider : CryptoUtils.getKeyProvider(this.conf, new SecureRandom());
        for (HadoopShims.KeyMetadata key : keyOverrides.values()) {
            this.keys.put(key.getKeyName(), new WriterEncryptionKey(key));
        }
        int variantCount = this.visitTypeTree(schema, false, this.keyProvider);
        int nextId = 0;
        if (variantCount > 0) {
            for (MaskDescriptionImpl mask : this.maskDescriptions.values()) {
                mask.setId(nextId++);
                for (TypeDescription column : mask.getColumns()) {
                    this.columnMaskDescriptions[column.getId()] = mask;
                }
            }
        }
        nextId = 0;
        int nextVariantId = 0;
        WriterEncryptionVariant[] result = new WriterEncryptionVariant[variantCount];
        for (WriterEncryptionKey key : this.keys.values()) {
            key.setId(nextId++);
            key.sortRoots();
            WriterEncryptionVariant[] writerEncryptionVariantArray = key.getEncryptionRoots();
            int n = writerEncryptionVariantArray.length;
            for (int i = 0; i < n; ++i) {
                WriterEncryptionVariant variant;
                result[nextVariantId] = variant = writerEncryptionVariantArray[i];
                this.columnEncryption[variant.getRoot().getId()] = variant;
                variant.setId(nextVariantId++);
            }
        }
        return result;
    }

    @Override
    public long estimateMemory() {
        return this.treeWriter.estimateMemory();
    }

    static {
        try {
            if (!"java".equalsIgnoreCase(System.getProperty("orc.compression.zstd.impl"))) {
                Native.load();
            }
        }
        catch (ExceptionInInitializerError | UnsatisfiedLinkError e) {
            LOG.warn("Unable to load zstd-jni library for your platform. Using builtin-java classes where applicable");
        }
    }

    private class StreamFactory
    implements WriterContext {
        private StreamFactory() {
        }

        @Override
        public OutStream createStream(StreamName name) throws IOException {
            StreamOptions options = SerializationUtils.getCustomizedCodec(WriterImpl.this.unencryptedOptions, WriterImpl.this.compressionStrategy, name.getKind());
            WriterEncryptionVariant encryption = (WriterEncryptionVariant)name.getEncryption();
            if (encryption != null) {
                if (options == WriterImpl.this.unencryptedOptions) {
                    options = new StreamOptions(options);
                }
                options.withEncryption(encryption.getKeyDescription().getAlgorithm(), encryption.getFileFooterKey()).modifyIv(CryptoUtils.modifyIvForStream(name, 1L));
            }
            return new OutStream(name, options, WriterImpl.this.physicalWriter.createDataStream(name));
        }

        @Override
        public int getRowIndexStride() {
            return WriterImpl.this.rowIndexStride;
        }

        @Override
        public boolean buildIndex() {
            return WriterImpl.this.buildIndex;
        }

        @Override
        public boolean isCompressed() {
            return WriterImpl.this.unencryptedOptions.getCodec() != null;
        }

        @Override
        public OrcFile.EncodingStrategy getEncodingStrategy() {
            return WriterImpl.this.encodingStrategy;
        }

        @Override
        public boolean[] getBloomFilterColumns() {
            return WriterImpl.this.bloomFilterColumns;
        }

        @Override
        public double getBloomFilterFPP() {
            return WriterImpl.this.bloomFilterFpp;
        }

        @Override
        public Configuration getConfiguration() {
            return WriterImpl.this.conf;
        }

        @Override
        public OrcFile.Version getVersion() {
            return WriterImpl.this.version;
        }

        @Override
        public PhysicalWriter getPhysicalWriter() {
            return WriterImpl.this.physicalWriter;
        }

        @Override
        public OrcFile.BloomFilterVersion getBloomFilterVersion() {
            return WriterImpl.this.bloomFilterVersion;
        }

        @Override
        public void writeIndex(StreamName name, OrcProto.RowIndex.Builder index) throws IOException {
            WriterImpl.this.physicalWriter.writeIndex(name, index);
        }

        @Override
        public void writeBloomFilter(StreamName name, OrcProto.BloomFilterIndex.Builder bloom) throws IOException {
            WriterImpl.this.physicalWriter.writeBloomFilter(name, bloom);
        }

        @Override
        public WriterEncryptionVariant getEncryption(int columnId) {
            return columnId < WriterImpl.this.columnEncryption.length ? WriterImpl.this.columnEncryption[columnId] : null;
        }

        @Override
        public DataMask getUnencryptedMask(int columnId) {
            MaskDescriptionImpl descr;
            if (WriterImpl.this.columnMaskDescriptions != null && (descr = WriterImpl.this.columnMaskDescriptions[columnId]) != null) {
                return DataMask.Factory.build(descr, WriterImpl.this.schema.findSubtype(columnId), type -> WriterImpl.this.columnMaskDescriptions[type.getId()]);
            }
            return null;
        }

        @Override
        public void setEncoding(int column, WriterEncryptionVariant encryption, OrcProto.ColumnEncoding encoding) {
            if (encryption == null) {
                WriterImpl.this.unencryptedEncodings.add(encoding);
            } else {
                encryption.addEncoding(encoding);
            }
        }

        @Override
        public void writeStatistics(StreamName name, OrcProto.ColumnStatistics.Builder stats) throws IOException {
            WriterImpl.this.physicalWriter.writeStatistics(name, stats);
        }

        @Override
        public boolean getUseUTCTimestamp() {
            return WriterImpl.this.useUTCTimeZone;
        }

        @Override
        public double getDictionaryKeySizeThreshold(int columnId) {
            return WriterImpl.this.directEncodingColumns[columnId] ? 0.0 : WriterImpl.this.dictionaryKeySizeThreshold;
        }

        @Override
        public boolean getProlepticGregorian() {
            return WriterImpl.this.useProlepticGregorian;
        }
    }
}

