/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.manifest.BucketEntry;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;

public class BucketsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String BUCKETS = "buckets";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "partition", SerializationUtils.newStringType(true)), new DataField(1, "bucket", DataTypes.INT().notNull()), new DataField(2, "record_count", new BigIntType(false)), new DataField(3, "file_size_in_bytes", new BigIntType(false)), new DataField(4, "file_count", new BigIntType(false)), new DataField(5, "last_update_time", DataTypes.TIMESTAMP_MILLIS())));
    private final FileStoreTable storeTable;

    public BucketsTable(FileStoreTable storeTable) {
        this.storeTable = storeTable;
    }

    @Override
    public String name() {
        return this.storeTable.name() + "$" + BUCKETS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Arrays.asList("partition", "bucket");
    }

    @Override
    public FileIO fileIO() {
        return this.storeTable.fileIO();
    }

    @Override
    public InnerTableScan newScan() {
        return new BucketsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new BucketsRead(this.storeTable);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new BucketsTable((FileStoreTable)this.storeTable.copy((Map)dynamicOptions));
    }

    private static class BucketsRead
    implements InnerTableRead {
        private final FileStoreTable fileStoreTable;
        private RowType readType;

        public BucketsRead(FileStoreTable table) {
            this.fileStoreTable = table;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof BucketsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            List<BucketEntry> buckets = this.fileStoreTable.newSnapshotReader().bucketEntries();
            CastExecutor<?, ?> partitionCastExecutor = CastExecutors.resolveToString(this.fileStoreTable.schema().logicalPartitionType());
            Iterator iterator2 = buckets.stream().map(bucketEntry -> this.toRow((BucketEntry)bucketEntry, (CastExecutor<InternalRow, BinaryString>)partitionCastExecutor)).sorted(Comparator.comparing(row -> row.getString(0)).thenComparing(row -> row.getInt(1))).iterator();
            if (this.readType != null) {
                iterator2 = Iterators.transform(iterator2, row -> ProjectedRow.from(this.readType, TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(iterator2);
        }

        private InternalRow toRow(BucketEntry entry, CastExecutor<InternalRow, BinaryString> partitionCastExecutor) {
            return GenericRow.of(partitionCastExecutor.cast(entry.partition()), entry.bucket(), entry.recordCount(), entry.fileSizeInBytes(), entry.fileCount(), Timestamp.fromLocalDateTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(entry.lastFileCreationTime()), ZoneId.systemDefault())));
        }
    }

    private static class BucketsSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;

        private BucketsSplit() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }
    }

    private static class BucketsScan
    extends ReadOnceTableScan {
        private BucketsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new BucketsSplit());
        }
    }
}

