/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.Function;

public class BinPacking {
    private BinPacking() {
    }

    public static <T> List<List<T>> packForOrdered(Iterable<T> items, Function<T, Long> weightFunc, long targetWeight) {
        ArrayList<List<T>> packed = new ArrayList<List<T>>();
        ArrayList<T> binItems = new ArrayList<T>();
        long binWeight = 0L;
        for (T item : items) {
            long weight = weightFunc.apply(item);
            if (binWeight + weight > targetWeight && binItems.size() > 0) {
                packed.add(binItems);
                binItems = new ArrayList();
                binWeight = 0L;
            }
            binWeight += weight;
            binItems.add(item);
        }
        if (binItems.size() > 0) {
            packed.add(binItems);
        }
        return packed;
    }

    public static <T> List<List<T>> packForFixedBinNumber(Iterable<T> items, Function<T, Long> weightFunc, int binNumber) {
        ArrayList<Object> sorted2 = new ArrayList<Object>();
        items.forEach(sorted2::add);
        sorted2.sort(Comparator.comparingLong(weightFunc::apply));
        PriorityQueue<FixedNumberBin> bins = new PriorityQueue<FixedNumberBin>();
        for (Object e : sorted2) {
            long weight = weightFunc.apply(e);
            FixedNumberBin bin2 = bins.size() < binNumber ? new FixedNumberBin() : (FixedNumberBin)bins.poll();
            bin2.add(e, weight);
            bins.add(bin2);
        }
        ArrayList<List<T>> packed = new ArrayList<List<T>>();
        bins.forEach(bin -> packed.add(((FixedNumberBin)bin).items));
        return packed;
    }

    private static class FixedNumberBin<T>
    implements Comparable<FixedNumberBin<T>> {
        private final List<T> items = new ArrayList<T>();
        private long binWeight = 0L;

        private FixedNumberBin() {
        }

        void add(T item, long weight) {
            this.binWeight += weight;
            this.items.add(item);
        }

        @Override
        public int compareTo(FixedNumberBin<T> other) {
            return Long.compare(this.binWeight, other.binWeight);
        }
    }
}

