/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public enum StorageType {
    RAM_DISK(true),
    SSD(false),
    DISK(false),
    ARCHIVE(false),
    PROVIDED(false);

    private final boolean isTransient;
    public static final StorageType DEFAULT;
    public static final StorageType[] EMPTY_ARRAY;
    private static final StorageType[] VALUES;

    private StorageType(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean supportTypeQuota() {
        return !this.isTransient;
    }

    public boolean isMovable() {
        return !this.isTransient;
    }

    public static List<StorageType> asList() {
        return Arrays.asList(VALUES);
    }

    public static List<StorageType> getMovableTypes() {
        return StorageType.getNonTransientTypes();
    }

    public static List<StorageType> getTypesSupportingQuota() {
        return StorageType.getNonTransientTypes();
    }

    public static StorageType parseStorageType(int i) {
        return VALUES[i];
    }

    public static StorageType parseStorageType(String s2) {
        return StorageType.valueOf(StringUtils.toUpperCase(s2));
    }

    private static List<StorageType> getNonTransientTypes() {
        ArrayList<StorageType> nonTransientTypes = new ArrayList<StorageType>();
        for (StorageType t2 : VALUES) {
            if (t2.isTransient) continue;
            nonTransientTypes.add(t2);
        }
        return nonTransientTypes;
    }

    static {
        DEFAULT = DISK;
        EMPTY_ARRAY = new StorageType[0];
        VALUES = StorageType.values();
    }
}

