/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.time.Duration;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.RateLimiter;
import org.apache.hadoop.util.RateLimiting;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class RateLimitingFactory {
    private static final RateLimiting UNLIMITED = new NoRateLimiting();
    private static final Duration INSTANTLY = Duration.ofMillis(0L);

    private RateLimitingFactory() {
    }

    public static RateLimiting unlimitedRate() {
        return UNLIMITED;
    }

    public static RateLimiting create(int capacity) {
        return capacity == 0 ? RateLimitingFactory.unlimitedRate() : new RestrictedRateLimiting(capacity);
    }

    private static final class RestrictedRateLimiting
    implements RateLimiting {
        private final RateLimiter limiter;

        private RestrictedRateLimiting(int capacityPerSecond) {
            this.limiter = RateLimiter.create(capacityPerSecond);
        }

        @Override
        public Duration acquire(int requestedCapacity) {
            double delayMillis = this.limiter.acquire(requestedCapacity);
            return delayMillis == 0.0 ? INSTANTLY : Duration.ofMillis((long)(delayMillis * 1000.0));
        }
    }

    private static class NoRateLimiting
    implements RateLimiting {
        private NoRateLimiting() {
        }

        @Override
        public Duration acquire(int requestedCapacity) {
            return INSTANTLY;
        }
    }
}

