/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.source;

import java.math.BigDecimal;
import org.apache.fluss.lake.paimon.source.FlussArrayAsPaimonArray;
import org.apache.fluss.lake.paimon.source.FlussMapAsPaimonMap;
import org.apache.fluss.row.Decimal;
import org.apache.fluss.row.InternalArray;
import org.apache.fluss.row.InternalMap;
import org.apache.fluss.row.InternalRow;
import org.apache.fluss.row.TimestampLtz;
import org.apache.fluss.row.TimestampNtz;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.variant.Variant;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;

public class FlussRowAsPaimonRow
implements org.apache.paimon.data.InternalRow {
    protected InternalRow internalRow;
    protected final RowType tableRowType;

    public FlussRowAsPaimonRow(RowType tableTowType) {
        this.tableRowType = tableTowType;
    }

    public FlussRowAsPaimonRow(InternalRow internalRow, RowType tableTowType) {
        this.internalRow = internalRow;
        this.tableRowType = tableTowType;
    }

    public int getFieldCount() {
        return this.internalRow.getFieldCount();
    }

    public RowKind getRowKind() {
        return RowKind.INSERT;
    }

    public void setRowKind(RowKind rowKind) {
    }

    public boolean isNullAt(int pos) {
        return this.internalRow.isNullAt(pos);
    }

    public boolean getBoolean(int pos) {
        return this.internalRow.getBoolean(pos);
    }

    public byte getByte(int pos) {
        return this.internalRow.getByte(pos);
    }

    public short getShort(int pos) {
        return this.internalRow.getShort(pos);
    }

    public int getInt(int pos) {
        return this.internalRow.getInt(pos);
    }

    public long getLong(int pos) {
        return this.internalRow.getLong(pos);
    }

    public float getFloat(int pos) {
        return this.internalRow.getFloat(pos);
    }

    public double getDouble(int pos) {
        return this.internalRow.getDouble(pos);
    }

    public BinaryString getString(int pos) {
        return BinaryString.fromBytes((byte[])this.internalRow.getString(pos).toBytes());
    }

    public org.apache.paimon.data.Decimal getDecimal(int pos, int precision, int scale) {
        Decimal flussDecimal = this.internalRow.getDecimal(pos, precision, scale);
        if (flussDecimal.isCompact()) {
            return org.apache.paimon.data.Decimal.fromUnscaledLong((long)flussDecimal.toUnscaledLong(), (int)precision, (int)scale);
        }
        return org.apache.paimon.data.Decimal.fromBigDecimal((BigDecimal)flussDecimal.toBigDecimal(), (int)precision, (int)scale);
    }

    public Timestamp getTimestamp(int pos, int precision) {
        DataType paimonTimestampType = this.tableRowType.getTypeAt(pos);
        switch (paimonTimestampType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                if (TimestampNtz.isCompact((int)precision)) {
                    return Timestamp.fromEpochMillis((long)this.internalRow.getTimestampNtz(pos, precision).getMillisecond());
                }
                TimestampNtz timestampNtz = this.internalRow.getTimestampNtz(pos, precision);
                return Timestamp.fromEpochMillis((long)timestampNtz.getMillisecond(), (int)timestampNtz.getNanoOfMillisecond());
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                if (TimestampLtz.isCompact((int)precision)) {
                    return Timestamp.fromEpochMillis((long)this.internalRow.getTimestampLtz(pos, precision).getEpochMillisecond());
                }
                TimestampLtz timestampLtz = this.internalRow.getTimestampLtz(pos, precision);
                return Timestamp.fromEpochMillis((long)timestampLtz.getEpochMillisecond(), (int)timestampLtz.getNanoOfMillisecond());
            }
        }
        throw new UnsupportedOperationException("Unsupported data type to get timestamp: " + paimonTimestampType);
    }

    public byte[] getBinary(int pos) {
        return this.internalRow.getBytes(pos);
    }

    public Variant getVariant(int i) {
        throw new UnsupportedOperationException("getVariant is not support for Fluss record currently.");
    }

    public org.apache.paimon.data.InternalArray getArray(int pos) {
        InternalArray flussArray = this.internalRow.getArray(pos);
        return flussArray == null ? null : new FlussArrayAsPaimonArray(flussArray, ((ArrayType)this.tableRowType.getTypeAt(pos)).getElementType());
    }

    public org.apache.paimon.data.InternalMap getMap(int pos) {
        InternalMap flussMap = this.internalRow.getMap(pos);
        if (flussMap == null) {
            return null;
        }
        MapType mapType = (MapType)this.tableRowType.getTypeAt(pos);
        return new FlussMapAsPaimonMap(flussMap, mapType.getKeyType(), mapType.getValueType());
    }

    public org.apache.paimon.data.InternalRow getRow(int pos, int numFields) {
        InternalRow nestedFlussRow = this.internalRow.getRow(pos, numFields);
        return nestedFlussRow == null ? null : new FlussRowAsPaimonRow(nestedFlussRow, (RowType)this.tableRowType.getTypeAt(pos));
    }
}

