/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.tiering;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.fluss.lake.paimon.tiering.PaimonCatalogProvider;
import org.apache.fluss.lake.paimon.tiering.PaimonWriteResult;
import org.apache.fluss.lake.paimon.tiering.RecordWriter;
import org.apache.fluss.lake.paimon.tiering.append.AppendOnlyWriter;
import org.apache.fluss.lake.paimon.tiering.mergetree.MergeTreeWriter;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.lake.writer.LakeWriter;
import org.apache.fluss.lake.writer.WriterInitContext;
import org.apache.fluss.metadata.TablePath;
import org.apache.fluss.record.LogRecord;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;

public class PaimonLakeWriter
implements LakeWriter<PaimonWriteResult> {
    private final Catalog paimonCatalog;
    private final RecordWriter<?> recordWriter;

    public PaimonLakeWriter(PaimonCatalogProvider paimonCatalogProvider, WriterInitContext writerInitContext) throws IOException {
        this.paimonCatalog = paimonCatalogProvider.get();
        FileStoreTable fileStoreTable = this.getTable(writerInitContext.tablePath(), writerInitContext.tableInfo().getTableConfig().isDataLakeAutoCompaction());
        List partitionKeys = fileStoreTable.partitionKeys();
        this.recordWriter = fileStoreTable.primaryKeys().isEmpty() ? new AppendOnlyWriter(fileStoreTable, writerInitContext.tableBucket(), writerInitContext.partition(), partitionKeys) : new MergeTreeWriter(fileStoreTable, writerInitContext.tableBucket(), writerInitContext.partition(), partitionKeys);
    }

    public void write(LogRecord record) throws IOException {
        try {
            this.recordWriter.write(record);
        }
        catch (Exception e) {
            throw new IOException("Failed to write Fluss record to Paimon.", e);
        }
    }

    public PaimonWriteResult complete() throws IOException {
        CommitMessage commitMessage;
        try {
            commitMessage = this.recordWriter.complete();
        }
        catch (Exception e) {
            throw new IOException("Failed to complete Paimon write.", e);
        }
        return new PaimonWriteResult(commitMessage);
    }

    public void close() throws IOException {
        try {
            if (this.recordWriter != null) {
                this.recordWriter.close();
            }
            if (this.paimonCatalog != null) {
                this.paimonCatalog.close();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to close PaimonLakeWriter.", e);
        }
    }

    private FileStoreTable getTable(TablePath tablePath, boolean isAutoCompaction) throws IOException {
        try {
            FileStoreTable table = (FileStoreTable)this.paimonCatalog.getTable(PaimonConversions.toPaimon(tablePath));
            Map<String, String> compactionOptions = Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), isAutoCompaction ? Boolean.FALSE.toString() : Boolean.TRUE.toString());
            return table.copy(compactionOptions);
        }
        catch (Exception e) {
            throw new IOException("Failed to get table " + tablePath + " in Paimon.", e);
        }
    }
}

