/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.lake.paimon.utils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.fluss.lake.paimon.utils.PaimonConversions;
import org.apache.fluss.predicate.And;
import org.apache.fluss.predicate.CompoundPredicate;
import org.apache.fluss.predicate.FieldRef;
import org.apache.fluss.predicate.FunctionVisitor;
import org.apache.fluss.predicate.LeafPredicate;
import org.apache.fluss.predicate.Or;
import org.apache.fluss.predicate.Predicate;
import org.apache.fluss.predicate.PredicateVisitor;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.types.RowType;

public class FlussToPaimonPredicateConverter
implements PredicateVisitor<org.apache.paimon.predicate.Predicate> {
    private final PredicateBuilder builder;
    private final LeafFunctionConverter converter = new LeafFunctionConverter();
    private final RowType paimonRowType;

    public FlussToPaimonPredicateConverter(RowType rowType) {
        this.builder = new PredicateBuilder(rowType);
        this.paimonRowType = rowType;
    }

    public static Optional<org.apache.paimon.predicate.Predicate> convert(RowType rowType, Predicate flussPredicate) {
        try {
            return Optional.of((org.apache.paimon.predicate.Predicate)flussPredicate.visit((PredicateVisitor)new FlussToPaimonPredicateConverter(rowType)));
        }
        catch (UnsupportedOperationException e) {
            return Optional.empty();
        }
    }

    public org.apache.paimon.predicate.Predicate visit(LeafPredicate predicate) {
        return (org.apache.paimon.predicate.Predicate)predicate.visit((PredicateVisitor)this.converter);
    }

    public org.apache.paimon.predicate.Predicate visit(CompoundPredicate predicate) {
        List children = predicate.children().stream().map(p -> (org.apache.paimon.predicate.Predicate)p.visit((PredicateVisitor)this)).collect(Collectors.toList());
        CompoundPredicate.Function function = predicate.function();
        if (function instanceof And) {
            return PredicateBuilder.and(children);
        }
        if (function instanceof Or) {
            return PredicateBuilder.or(children);
        }
        throw new UnsupportedOperationException("Unsupported fluss compound predicate function: " + predicate.function());
    }

    private class LeafFunctionConverter
    implements FunctionVisitor<org.apache.paimon.predicate.Predicate> {
        private LeafFunctionConverter() {
        }

        public org.apache.paimon.predicate.Predicate visitIsNotNull(FieldRef fieldRef) {
            return FlussToPaimonPredicateConverter.this.builder.isNotNull(fieldRef.index());
        }

        public org.apache.paimon.predicate.Predicate visitIsNull(FieldRef fieldRef) {
            return FlussToPaimonPredicateConverter.this.builder.isNull(fieldRef.index());
        }

        public org.apache.paimon.predicate.Predicate visitStartsWith(FieldRef fieldRef, Object literal) {
            return FlussToPaimonPredicateConverter.this.builder.startsWith(fieldRef.index(), this.convertToPaimonLiteral(fieldRef.index(), literal));
        }

        public org.apache.paimon.predicate.Predicate visitEndsWith(FieldRef fieldRef, Object literal) {
            return FlussToPaimonPredicateConverter.this.builder.endsWith(fieldRef.index(), this.convertToPaimonLiteral(fieldRef.index(), literal));
        }

        public org.apache.paimon.predicate.Predicate visitContains(FieldRef fieldRef, Object literal) {
            return FlussToPaimonPredicateConverter.this.builder.contains(fieldRef.index(), this.convertToPaimonLiteral(fieldRef.index(), literal));
        }

        public org.apache.paimon.predicate.Predicate visitLessThan(FieldRef fieldRef, Object literal) {
            return FlussToPaimonPredicateConverter.this.builder.lessThan(fieldRef.index(), this.convertToPaimonLiteral(fieldRef.index(), literal));
        }

        public org.apache.paimon.predicate.Predicate visitGreaterOrEqual(FieldRef fieldRef, Object literal) {
            return FlussToPaimonPredicateConverter.this.builder.greaterOrEqual(fieldRef.index(), this.convertToPaimonLiteral(fieldRef.index(), literal));
        }

        public org.apache.paimon.predicate.Predicate visitNotEqual(FieldRef fieldRef, Object literal) {
            return FlussToPaimonPredicateConverter.this.builder.notEqual(fieldRef.index(), this.convertToPaimonLiteral(fieldRef.index(), literal));
        }

        public org.apache.paimon.predicate.Predicate visitLessOrEqual(FieldRef fieldRef, Object literal) {
            return FlussToPaimonPredicateConverter.this.builder.lessOrEqual(fieldRef.index(), this.convertToPaimonLiteral(fieldRef.index(), literal));
        }

        public org.apache.paimon.predicate.Predicate visitEqual(FieldRef fieldRef, Object literal) {
            return FlussToPaimonPredicateConverter.this.builder.equal(fieldRef.index(), this.convertToPaimonLiteral(fieldRef.index(), literal));
        }

        public org.apache.paimon.predicate.Predicate visitGreaterThan(FieldRef fieldRef, Object literal) {
            return FlussToPaimonPredicateConverter.this.builder.greaterThan(fieldRef.index(), this.convertToPaimonLiteral(fieldRef.index(), literal));
        }

        public org.apache.paimon.predicate.Predicate visitIn(FieldRef fieldRef, List<Object> literals) {
            return FlussToPaimonPredicateConverter.this.builder.in(fieldRef.index(), literals.stream().map(literal -> this.convertToPaimonLiteral(fieldRef.index(), literal)).collect(Collectors.toList()));
        }

        public org.apache.paimon.predicate.Predicate visitNotIn(FieldRef fieldRef, List<Object> literals) {
            return FlussToPaimonPredicateConverter.this.builder.notIn(fieldRef.index(), literals.stream().map(literal -> this.convertToPaimonLiteral(fieldRef.index(), literal)).collect(Collectors.toList()));
        }

        public org.apache.paimon.predicate.Predicate visitAnd(List<org.apache.paimon.predicate.Predicate> children) {
            throw new UnsupportedOperationException("Unsupported visitAnd method.");
        }

        public org.apache.paimon.predicate.Predicate visitOr(List<org.apache.paimon.predicate.Predicate> children) {
            throw new UnsupportedOperationException("Unsupported visitOr method.");
        }

        private Object convertToPaimonLiteral(int fieldIndex, Object flussLiteral) {
            return PaimonConversions.toPaimonLiteral(FlussToPaimonPredicateConverter.this.paimonRowType.getTypeAt(fieldIndex), flussLiteral);
        }
    }
}

