/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluss.metrics.prometheus;

import io.prometheus.client.exporter.PushGateway;
import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import org.apache.fluss.metrics.prometheus.AbstractPrometheusReporter;
import org.apache.fluss.metrics.reporter.ScheduledMetricReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusPushGatewayReporter
extends AbstractPrometheusReporter
implements ScheduledMetricReporter {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusPushGatewayReporter.class);
    private final PushGateway pushGateway;
    private final String jobName;
    private final Map<String, String> groupingKey;
    private final boolean deleteOnShutdown;
    private final Duration pushInterval;

    public PrometheusPushGatewayReporter(URL hostUrl, String jobName, Map<String, String> groupingKey, boolean deleteOnShutdown, Duration pushInterval) {
        this.pushGateway = new PushGateway(hostUrl);
        this.jobName = jobName;
        this.groupingKey = groupingKey;
        this.deleteOnShutdown = deleteOnShutdown;
        this.pushInterval = pushInterval;
    }

    @Override
    public void close() {
        if (this.deleteOnShutdown) {
            try {
                this.pushGateway.delete(this.jobName, this.groupingKey);
                LOG.info("Deleted metrics from PushGateway.");
            }
            catch (IOException e) {
                LOG.warn("Could not delete metrics from PushGateway.", (Throwable)e);
            }
        }
        super.close();
    }

    public Duration scheduleInterval() {
        return this.pushInterval;
    }

    public void report() {
        try {
            this.pushGateway.push(this.registry, this.jobName, this.groupingKey);
        }
        catch (IOException e) {
            LOG.warn("Could not push metrics to PushGateway.", (Throwable)e);
        }
    }
}

