/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dynamodbv2.model.transform.EndpointMarshaller;
import java.io.Serializable;

public class Endpoint
implements Serializable,
Cloneable,
StructuredPojo {
    private String address;
    private Long cachePeriodInMinutes;

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public Endpoint withAddress(String address) {
        this.setAddress(address);
        return this;
    }

    public void setCachePeriodInMinutes(Long cachePeriodInMinutes) {
        this.cachePeriodInMinutes = cachePeriodInMinutes;
    }

    public Long getCachePeriodInMinutes() {
        return this.cachePeriodInMinutes;
    }

    public Endpoint withCachePeriodInMinutes(Long cachePeriodInMinutes) {
        this.setCachePeriodInMinutes(cachePeriodInMinutes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddress() != null) {
            sb.append("Address: ").append(this.getAddress()).append(",");
        }
        if (this.getCachePeriodInMinutes() != null) {
            sb.append("CachePeriodInMinutes: ").append(this.getCachePeriodInMinutes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        if (other.getAddress() == null ^ this.getAddress() == null) {
            return false;
        }
        if (other.getAddress() != null && !other.getAddress().equals(this.getAddress())) {
            return false;
        }
        if (other.getCachePeriodInMinutes() == null ^ this.getCachePeriodInMinutes() == null) {
            return false;
        }
        return other.getCachePeriodInMinutes() == null || other.getCachePeriodInMinutes().equals(this.getCachePeriodInMinutes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddress() == null ? 0 : this.getAddress().hashCode());
        hashCode = 31 * hashCode + (this.getCachePeriodInMinutes() == null ? 0 : this.getCachePeriodInMinutes().hashCode());
        return hashCode;
    }

    public Endpoint clone() {
        try {
            return (Endpoint)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

