/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compression;

import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.apache.paimon.compression.BlockDecompressor;
import org.apache.paimon.compression.BufferDecompressionException;
import org.apache.paimon.compression.CompressorUtils;

public class Lz4BlockDecompressor
implements BlockDecompressor {
    private final LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws BufferDecompressionException {
        int compressedLen = CompressorUtils.readIntLE(src, srcOff);
        int originalLen = CompressorUtils.readIntLE(src, srcOff + 4);
        CompressorUtils.validateLength(compressedLen, originalLen);
        if (dst.length - dstOff < originalLen) {
            throw new BufferDecompressionException("Buffer length too small");
        }
        if (src.length - srcOff - 8 < compressedLen) {
            throw new BufferDecompressionException("Source data is not integral for decompression.");
        }
        try {
            int compressedLen2 = this.decompressor.decompress(src, srcOff + 8, dst, dstOff, originalLen);
            if (compressedLen != compressedLen2) {
                throw new BufferDecompressionException("Input is corrupted");
            }
        }
        catch (LZ4Exception e) {
            throw new BufferDecompressionException("Input is corrupted", e);
        }
        return originalLen;
    }
}

