/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io.cache;

import java.io.IOException;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.io.cache.Cache;
import org.apache.paimon.io.cache.CacheBuilder;
import org.apache.paimon.io.cache.CacheCallback;
import org.apache.paimon.io.cache.CacheKey;
import org.apache.paimon.io.cache.CacheReader;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.options.MemorySize;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(CacheManager.class);
    public static final int REFRESH_COUNT = 10;
    private final Cache dataCache;
    private final Cache indexCache;
    private int fileReadCount;

    @VisibleForTesting
    public CacheManager(MemorySize maxMemorySize) {
        this(Cache.CacheType.GUAVA, maxMemorySize, 0.0);
    }

    public CacheManager(MemorySize dataMaxMemorySize, double highPriorityPoolRatio) {
        this(Cache.CacheType.GUAVA, dataMaxMemorySize, highPriorityPoolRatio);
    }

    public CacheManager(Cache.CacheType cacheType, MemorySize maxMemorySize, double highPriorityPoolRatio) {
        Preconditions.checkArgument(highPriorityPoolRatio >= 0.0 && highPriorityPoolRatio < 1.0, "The high priority pool ratio should in the range [0, 1).");
        MemorySize indexCacheSize = MemorySize.ofBytes((long)((double)maxMemorySize.getBytes() * highPriorityPoolRatio));
        MemorySize dataCacheSize = MemorySize.ofBytes((long)((double)maxMemorySize.getBytes() * (1.0 - highPriorityPoolRatio)));
        this.dataCache = CacheBuilder.newBuilder(cacheType).maximumWeight(dataCacheSize).build();
        this.indexCache = highPriorityPoolRatio == 0.0 ? this.dataCache : CacheBuilder.newBuilder(cacheType).maximumWeight(indexCacheSize).build();
        this.fileReadCount = 0;
        LOG.info("Initialize cache manager with data cache of {} and index cache of {}.", (Object)dataCacheSize, (Object)indexCacheSize);
    }

    @VisibleForTesting
    public Cache dataCache() {
        return this.dataCache;
    }

    @VisibleForTesting
    public Cache indexCache() {
        return this.indexCache;
    }

    public MemorySegment getPage(CacheKey key, CacheReader reader, CacheCallback callback) {
        Cache cache = key.isIndex() ? this.indexCache : this.dataCache;
        Cache.CacheValue value = cache.get(key, k -> {
            ++this.fileReadCount;
            try {
                return new Cache.CacheValue(MemorySegment.wrap(reader.read(key)), callback);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        return Preconditions.checkNotNull(value, (String)String.format((String)"Cache result for key(%s) is null", (Object[])new Object[]{key})).segment;
    }

    public void invalidPage(CacheKey key) {
        if (key.isIndex()) {
            this.indexCache.invalidate(key);
        } else {
            this.dataCache.invalidate(key);
        }
    }

    public int fileReadCount() {
        return this.fileReadCount;
    }

    public static class SegmentContainer {
        private final MemorySegment segment;
        private int accessCount;

        public SegmentContainer(MemorySegment segment) {
            this.segment = segment;
            this.accessCount = 0;
        }

        public MemorySegment access() {
            ++this.accessCount;
            return this.segment;
        }

        public int getAccessCount() {
            return this.accessCount;
        }
    }
}

