/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.plugin;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.paimon.plugin.ComponentClassLoader;

public class PluginLoader {
    public static final String[] PARENT_FIRST_LOGGING_PATTERNS = new String[]{"org.slf4j", "org.apache.log4j", "org.apache.logging", "org.apache.commons.logging", "ch.qos.logback"};
    private static final String[] OWNER_CLASSPATH = (String[])Stream.concat(Arrays.stream(PARENT_FIRST_LOGGING_PATTERNS), Stream.of("javax.xml.bind", "org.apache.paimon.shade.org.codehaus.janino", "org.apache.paimon.shade.org.codehaus.commons", "org.apache.commons.lang3")).toArray(String[]::new);
    private static final String[] COMPONENT_CLASSPATH = new String[]{"org.apache.paimon"};
    private final ComponentClassLoader submoduleClassLoader;

    public PluginLoader(String dirName) {
        if (!dirName.endsWith("/")) {
            dirName = dirName + "/";
        }
        ClassLoader ownerClassLoader = PluginLoader.class.getClassLoader();
        this.submoduleClassLoader = new ComponentClassLoader(new URL[]{ownerClassLoader.getResource(dirName)}, ownerClassLoader, OWNER_CLASSPATH, COMPONENT_CLASSPATH);
    }

    public <T> T discover(Class<T> clazz) {
        ArrayList results = new ArrayList();
        ServiceLoader.load(clazz, this.submoduleClassLoader).iterator().forEachRemaining(results::add);
        if (results.size() != 1) {
            throw new RuntimeException("Found " + results.size() + " classes implementing " + clazz.getName() + ". They are:\n" + results.stream().map(t -> t.getClass().getName()).collect(Collectors.joining("\n")));
        }
        return (T)results.get(0);
    }

    public <T> T newInstance(String name) {
        try {
            return (T)this.submoduleClassLoader.loadClass(name).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public ClassLoader submoduleClassLoader() {
        return this.submoduleClassLoader;
    }
}

