/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTCatalogInternalOptions;
import org.apache.paimon.rest.RESTUtil;
import org.apache.paimon.shade.guava30.com.google.common.base.Joiner;

public class ResourcePaths {
    protected static final String V1 = "/v1";
    protected static final String DATABASES = "databases";
    protected static final String TABLES = "tables";
    protected static final String PARTITIONS = "partitions";
    protected static final String BRANCHES = "branches";
    protected static final String SNAPSHOTS = "snapshots";
    protected static final String VIEWS = "views";
    protected static final String TABLE_DETAILS = "table-details";
    protected static final String VIEW_DETAILS = "view-details";
    protected static final String ROLLBACK = "rollback";
    protected static final String REGISTER = "register";
    protected static final String FUNCTIONS = "functions";
    protected static final String FUNCTION_DETAILS = "function-details";
    private static final Joiner SLASH = Joiner.on("/").skipNulls();
    private final String prefix;

    public static String config() {
        return String.format("%s/config", V1);
    }

    public static ResourcePaths forCatalogProperties(Options options) {
        return new ResourcePaths(options.get(RESTCatalogInternalOptions.PREFIX));
    }

    public ResourcePaths(String prefix) {
        this.prefix = RESTUtil.encodeString(prefix);
    }

    public String databases() {
        return SLASH.join(V1, this.prefix, DATABASES);
    }

    public String database(String databaseName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName));
    }

    public String tables(String databaseName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES);
    }

    public String tableDetails(String databaseName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLE_DETAILS);
    }

    public String tables() {
        return SLASH.join(V1, this.prefix, TABLES);
    }

    public String table(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName));
    }

    public String renameTable() {
        return SLASH.join(V1, this.prefix, TABLES, "rename");
    }

    public String commitTable(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), "commit");
    }

    public String rollbackTable(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), ROLLBACK);
    }

    public String registerTable(String databaseName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), REGISTER);
    }

    public String tableToken(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), "token");
    }

    public String tableSnapshot(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), "snapshot");
    }

    public String tableSnapshot(String databaseName, String objectName, String version) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), SNAPSHOTS, version);
    }

    public String snapshots(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), SNAPSHOTS);
    }

    public String authTable(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), "auth");
    }

    public String partitions(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), PARTITIONS);
    }

    public String markDonePartitions(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), PARTITIONS, "mark");
    }

    public String branches(String databaseName, String objectName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), BRANCHES);
    }

    public String branch(String databaseName, String objectName, String branchName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(objectName), BRANCHES, RESTUtil.encodeString(branchName));
    }

    public String forwardBranch(String databaseName, String tableName, String branch) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), TABLES, RESTUtil.encodeString(tableName), BRANCHES, RESTUtil.encodeString(branch), "forward");
    }

    public String views(String databaseName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), VIEWS);
    }

    public String viewDetails(String databaseName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), VIEW_DETAILS);
    }

    public String views() {
        return SLASH.join(V1, this.prefix, VIEWS);
    }

    public String view(String databaseName, String viewName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), VIEWS, RESTUtil.encodeString(viewName));
    }

    public String renameView() {
        return SLASH.join(V1, this.prefix, VIEWS, "rename");
    }

    public String functions(String databaseName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), FUNCTIONS);
    }

    public String functions() {
        return SLASH.join(V1, this.prefix, FUNCTIONS);
    }

    public String functionDetails(String databaseName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), FUNCTION_DETAILS);
    }

    public String function(String databaseName, String functionName) {
        return SLASH.join(V1, this.prefix, DATABASES, RESTUtil.encodeString(databaseName), FUNCTIONS, RESTUtil.encodeString(functionName));
    }
}

