/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.splitread;

import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.operation.DataEvolutionSplitRead;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.splitread.SplitReadConfig;
import org.apache.paimon.table.source.splitread.SplitReadProvider;
import org.apache.paimon.utils.LazyField;

public class DataEvolutionSplitReadProvider
implements SplitReadProvider {
    private final LazyField<DataEvolutionSplitRead> splitRead = new LazyField<DataEvolutionSplitRead>(() -> {
        DataEvolutionSplitRead read = (DataEvolutionSplitRead)supplier.get();
        splitReadConfig.config(read);
        return read;
    });

    public DataEvolutionSplitReadProvider(Supplier<DataEvolutionSplitRead> supplier, SplitReadConfig splitReadConfig) {
    }

    @Override
    public boolean match(DataSplit split, boolean forceKeepDelete) {
        List<DataFileMeta> files = split.dataFiles();
        if (files.size() < 2) {
            return false;
        }
        HashSet<Long> firstRowIds = new HashSet<Long>();
        for (DataFileMeta file : files) {
            Long current = file.firstRowId();
            if (current == null || !file.fileSource().isPresent() || file.fileSource().get() != FileSource.APPEND) {
                return false;
            }
            firstRowIds.add(current);
        }
        return firstRowIds.size() != files.size();
    }

    public LazyField<DataEvolutionSplitRead> get() {
        return this.splitRead;
    }
}

