/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.And;
import org.apache.paimon.predicate.CompoundPredicate;
import org.apache.paimon.predicate.Equal;
import org.apache.paimon.predicate.GreaterOrEqual;
import org.apache.paimon.predicate.GreaterThan;
import org.apache.paimon.predicate.InPredicateVisitor;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.LeafPredicateExtractor;
import org.apache.paimon.predicate.LessOrEqual;
import org.apache.paimon.predicate.LessThan;
import org.apache.paimon.predicate.Or;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.SnapshotManager;

public class SnapshotsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String SNAPSHOTS = "snapshots";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "snapshot_id", new BigIntType(false)), new DataField(1, "schema_id", new BigIntType(false)), new DataField(2, "commit_user", SerializationUtils.newStringType(false)), new DataField(3, "commit_identifier", new BigIntType(false)), new DataField(4, "commit_kind", SerializationUtils.newStringType(false)), new DataField(5, "commit_time", new TimestampType(false, 3)), new DataField(6, "base_manifest_list", SerializationUtils.newStringType(false)), new DataField(7, "delta_manifest_list", SerializationUtils.newStringType(false)), new DataField(8, "changelog_manifest_list", SerializationUtils.newStringType(true)), new DataField(9, "total_record_count", new BigIntType(true)), new DataField(10, "delta_record_count", new BigIntType(true)), new DataField(11, "changelog_record_count", new BigIntType(true)), new DataField(12, "watermark", new BigIntType(true))));
    private final FileIO fileIO;
    private final Path location;
    private final FileStoreTable dataTable;

    public SnapshotsTable(FileStoreTable dataTable) {
        this.fileIO = dataTable.fileIO();
        this.location = dataTable.location();
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + SNAPSHOTS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("snapshot_id");
    }

    @Override
    public FileIO fileIO() {
        return this.dataTable.fileIO();
    }

    @Override
    public InnerTableScan newScan() {
        return new SnapshotsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new SnapshotsRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new SnapshotsTable((FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private class SnapshotsRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private RowType readType;
        private Optional<Long> optionalFilterSnapshotIdMax = Optional.empty();
        private Optional<Long> optionalFilterSnapshotIdMin = Optional.empty();
        private final List<Long> snapshotIds = new ArrayList<Long>();

        public SnapshotsRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            if (predicate == null) {
                return this;
            }
            String leafName = "snapshot_id";
            if (predicate instanceof CompoundPredicate) {
                CompoundPredicate compoundPredicate = (CompoundPredicate)predicate;
                List<Predicate> children = compoundPredicate.children();
                if (compoundPredicate.function() instanceof And) {
                    for (Predicate leaf : children) {
                        this.handleLeafPredicate(leaf, leafName);
                    }
                }
                if (compoundPredicate.function() instanceof Or) {
                    InPredicateVisitor.extractInElements(predicate, leafName).ifPresent(leafs -> leafs.forEach(leaf -> this.snapshotIds.add(Long.parseLong(leaf.toString()))));
                }
            } else {
                this.handleLeafPredicate(predicate, leafName);
            }
            return this;
        }

        public void handleLeafPredicate(Predicate predicate, String leafName) {
            LeafPredicate snapshotPred = predicate.visit(LeafPredicateExtractor.INSTANCE).get(leafName);
            if (snapshotPred != null) {
                if (snapshotPred.function() instanceof Equal) {
                    this.optionalFilterSnapshotIdMin = Optional.of((Long)snapshotPred.literals().get(0));
                    this.optionalFilterSnapshotIdMax = Optional.of((Long)snapshotPred.literals().get(0));
                }
                if (snapshotPred.function() instanceof GreaterThan) {
                    this.optionalFilterSnapshotIdMin = Optional.of((Long)snapshotPred.literals().get(0) + 1L);
                }
                if (snapshotPred.function() instanceof GreaterOrEqual) {
                    this.optionalFilterSnapshotIdMin = Optional.of((Long)snapshotPred.literals().get(0));
                }
                if (snapshotPred.function() instanceof LessThan) {
                    this.optionalFilterSnapshotIdMax = Optional.of((Long)snapshotPred.literals().get(0) - 1L);
                }
                if (snapshotPred.function() instanceof LessOrEqual) {
                    this.optionalFilterSnapshotIdMax = Optional.of((Long)snapshotPred.literals().get(0));
                }
            }
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof SnapshotsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            SnapshotManager snapshotManager = SnapshotsTable.this.dataTable.snapshotManager();
            Iterator<Snapshot> snapshots = !this.snapshotIds.isEmpty() ? snapshotManager.snapshotsWithId(this.snapshotIds) : snapshotManager.snapshotsWithinRange(this.optionalFilterSnapshotIdMax, this.optionalFilterSnapshotIdMin);
            Iterator rows = Iterators.transform(snapshots, this::toRow);
            if (this.readType != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.readType, TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(Snapshot snapshot) {
            return GenericRow.of(snapshot.id(), snapshot.schemaId(), BinaryString.fromString(snapshot.commitUser()), snapshot.commitIdentifier(), BinaryString.fromString(snapshot.commitKind().toString()), Timestamp.fromLocalDateTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(snapshot.timeMillis()), ZoneId.systemDefault())), BinaryString.fromString(snapshot.baseManifestList()), BinaryString.fromString(snapshot.deltaManifestList()), BinaryString.fromString(snapshot.changelogManifestList()), snapshot.totalRecordCount(), snapshot.deltaRecordCount(), snapshot.changelogRecordCount(), snapshot.watermark());
        }
    }

    private static class SnapshotsSplit
    extends SingletonSplit {
        private static final long serialVersionUID = 1L;
        private final Path location;

        private SnapshotsSplit(Path location) {
            this.location = location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotsSplit that = (SnapshotsSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class SnapshotsScan
    extends ReadOnceTableScan {
        private SnapshotsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            return () -> Collections.singletonList(new SnapshotsSplit(SnapshotsTable.this.location));
        }
    }
}

