/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.fs.Path;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public interface BranchManager {
    public static final String BRANCH_PREFIX = "branch-";

    public void createBranch(String var1);

    public void createBranch(String var1, @Nullable String var2);

    public void dropBranch(String var1);

    public void fastForward(String var1);

    public List<String> branches();

    default public boolean branchExists(String branchName) {
        return this.branches().contains(branchName);
    }

    public static String branchPath(Path tablePath, String branch) {
        return BranchManager.isMainBranch(branch) ? tablePath.toString() : tablePath.toString() + "/branch/" + BRANCH_PREFIX + branch;
    }

    public static String normalizeBranch(String branch) {
        return StringUtils.isNullOrWhitespaceOnly(branch) ? "main" : branch;
    }

    public static boolean isMainBranch(String branch) {
        return branch.equals("main");
    }

    public static void validateBranch(String branchName) {
        Preconditions.checkArgument(!BranchManager.isMainBranch(branchName), String.format("Branch name '%s' is the default branch and cannot be used.", "main"));
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(branchName), "Branch name '%s' is blank.", branchName);
        Preconditions.checkArgument(!branchName.chars().allMatch(Character::isDigit), "Branch name cannot be pure numeric string but is '%s'.", branchName);
    }

    public static void fastForwardValidate(String branchName, String currentBranch) {
        Preconditions.checkArgument(!branchName.equals("main"), "Branch name '%s' do not use in fast-forward.", branchName);
        Preconditions.checkArgument(!StringUtils.isNullOrWhitespaceOnly(branchName), "Branch name '%s' is blank.", branchName);
        Preconditions.checkArgument(!branchName.equals(currentBranch), "Fast-forward from the current branch '%s' is not allowed.", branchName);
    }
}

