/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.view;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.view.View;
import org.apache.paimon.view.ViewSchema;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ViewImpl
implements View {
    private final Identifier identifier;
    private final ViewSchema viewSchema;

    public ViewImpl(Identifier identifier, List<DataField> fields, String query, Map<String, String> dialects, @Nullable String comment, Map<String, String> options) {
        this.identifier = identifier;
        this.viewSchema = new ViewSchema(fields, query, dialects, comment, options);
    }

    @Override
    public String name() {
        return this.identifier.getObjectName();
    }

    @Override
    public String fullName() {
        return this.identifier.getFullName();
    }

    @Override
    public RowType rowType() {
        return new RowType(false, this.viewSchema.fields());
    }

    @Override
    public String query() {
        return this.viewSchema.query();
    }

    @Override
    public Map<String, String> dialects() {
        return this.viewSchema.dialects();
    }

    @Override
    public Optional<String> comment() {
        return Optional.ofNullable(this.viewSchema.comment());
    }

    @Override
    public Map<String, String> options() {
        return this.viewSchema.options();
    }

    @Override
    public View copy(Map<String, String> dynamicOptions) {
        HashMap<String, String> newOptions = new HashMap<String, String>(this.options());
        newOptions.putAll(dynamicOptions);
        return new ViewImpl(this.identifier, this.viewSchema.fields(), this.query(), this.dialects(), this.viewSchema.comment(), newOptions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewImpl view = (ViewImpl)o;
        return Objects.equals(this.identifier, view.identifier) && Objects.equals(this.viewSchema, view.viewSchema);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.viewSchema);
    }
}

