/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.concurrent;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.concurrent.HadoopScheduledThreadPoolExecutor;
import org.apache.hadoop.util.concurrent.HadoopThreadPoolExecutor;
import org.slf4j.Logger;

public final class HadoopExecutors {
    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory2) {
        return new HadoopThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory2);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory2) {
        return new HadoopThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory2);
    }

    public static ExecutorService newFixedThreadPool(int nThreads) {
        return new HadoopThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ExecutorService newSingleThreadExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory2) {
        return Executors.newSingleThreadExecutor(threadFactory2);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        return new HadoopScheduledThreadPoolExecutor(corePoolSize);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory2) {
        return new HadoopScheduledThreadPoolExecutor(corePoolSize, threadFactory2);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory2) {
        return Executors.newSingleThreadScheduledExecutor(threadFactory2);
    }

    public static void shutdown(ExecutorService executorService, Logger logger, long timeout2, TimeUnit unit) {
        if (executorService == null) {
            return;
        }
        try {
            executorService.shutdown();
            logger.debug("Gracefully shutting down executor service. Waiting max {} {}", (Object)timeout2, (Object)unit);
            if (!executorService.awaitTermination(timeout2, unit)) {
                logger.debug("Executor service has not shutdown yet. Forcing. Will wait up to an additional {} {} for shutdown", (Object)timeout2, (Object)unit);
                executorService.shutdownNow();
            }
            if (executorService.awaitTermination(timeout2, unit)) {
                logger.debug("Succesfully shutdown executor service");
            } else {
                logger.error("Unable to shutdown executor service after timeout {} {}", (Object)(2L * timeout2), (Object)unit);
            }
        }
        catch (InterruptedException e) {
            logger.error("Interrupted while attempting to shutdown", (Throwable)e);
            executorService.shutdownNow();
        }
        catch (Exception e) {
            logger.warn("Exception closing executor service {}", (Object)e.getMessage());
            logger.debug("Exception closing executor service", (Throwable)e);
            throw e;
        }
    }

    private HadoopExecutors() {
    }
}

