/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.PrimitiveWrapper;
import org.apache.iceberg.variants.SerializedMetadata;
import org.apache.iceberg.variants.SerializedObject;
import org.apache.iceberg.variants.ShreddedObject;
import org.apache.iceberg.variants.ValueArray;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantUtil;
import org.apache.iceberg.variants.VariantValue;

public class Variants {
    private Variants() {
    }

    public static VariantMetadata emptyMetadata() {
        return SerializedMetadata.EMPTY_V1_METADATA;
    }

    public static VariantMetadata metadata(ByteBuffer metadata) {
        return SerializedMetadata.from((ByteBuffer)metadata);
    }

    public static VariantMetadata metadata(String ... fieldNames) {
        return Variants.metadata(Arrays.asList(fieldNames));
    }

    public static VariantMetadata metadata(Collection<String> fieldNames) {
        if (fieldNames.isEmpty()) {
            return Variants.emptyMetadata();
        }
        int numElements = fieldNames.size();
        ByteBuffer[] nameBuffers = new ByteBuffer[numElements];
        boolean sorted = true;
        String last = null;
        int pos = 0;
        int dataSize = 0;
        for (String name : fieldNames) {
            nameBuffers[pos] = ByteBuffer.wrap(name.getBytes(StandardCharsets.UTF_8));
            dataSize += nameBuffers[pos].remaining();
            if (last != null && last.compareTo(name) >= 0) {
                sorted = false;
            }
            last = name;
            ++pos;
        }
        int offsetSize = VariantUtil.sizeOf((int)dataSize);
        int offsetListOffset = 1 + offsetSize;
        int dataOffset = offsetListOffset + (1 + numElements) * offsetSize;
        int totalSize = dataOffset + dataSize;
        byte header = VariantUtil.metadataHeader((boolean)sorted, (int)offsetSize);
        ByteBuffer buffer = ByteBuffer.allocate(totalSize).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(0, header);
        VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)numElements, (int)1, (int)offsetSize);
        int nextOffset = 0;
        int index = 0;
        for (ByteBuffer nameBuffer : nameBuffers) {
            VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextOffset, (int)(offsetListOffset + index * offsetSize), (int)offsetSize);
            int nameSize = VariantUtil.writeBufferAbsolute((ByteBuffer)buffer, (int)(dataOffset + nextOffset), (ByteBuffer)nameBuffer);
            nextOffset += nameSize;
            ++index;
        }
        VariantUtil.writeLittleEndianUnsigned((ByteBuffer)buffer, (int)nextOffset, (int)(offsetListOffset + index * offsetSize), (int)offsetSize);
        return SerializedMetadata.from((ByteBuffer)buffer);
    }

    public static VariantValue value(VariantMetadata metadata, ByteBuffer value) {
        return VariantValue.from((VariantMetadata)metadata, (ByteBuffer)value);
    }

    public static ShreddedObject object(VariantMetadata metadata, VariantObject object) {
        return new ShreddedObject(metadata, object);
    }

    public static ShreddedObject object(VariantMetadata metadata) {
        return new ShreddedObject(metadata);
    }

    public static ShreddedObject object(VariantObject object) {
        if (object instanceof ShreddedObject) {
            return new ShreddedObject(((ShreddedObject)object).metadata(), object);
        }
        if (object instanceof SerializedObject) {
            return new ShreddedObject(((SerializedObject)object).metadata(), object);
        }
        throw new UnsupportedOperationException("Metadata is required for object: " + String.valueOf(object));
    }

    public static boolean isNull(ByteBuffer valueBuffer) {
        return VariantUtil.readByte((ByteBuffer)valueBuffer, (int)0) == 0;
    }

    public static ValueArray array() {
        return new ValueArray();
    }

    public static <T> VariantPrimitive<T> of(PhysicalType type, T value) {
        return new PrimitiveWrapper<T>(type, value);
    }

    public static VariantPrimitive<Void> ofNull() {
        return new PrimitiveWrapper<Object>(PhysicalType.NULL, null);
    }

    public static VariantPrimitive<Boolean> of(boolean value) {
        return new PrimitiveWrapper<Boolean>(PhysicalType.BOOLEAN_TRUE, value);
    }

    public static VariantPrimitive<Byte> of(byte value) {
        return new PrimitiveWrapper<Byte>(PhysicalType.INT8, value);
    }

    public static VariantPrimitive<Short> of(short value) {
        return new PrimitiveWrapper<Short>(PhysicalType.INT16, value);
    }

    public static VariantPrimitive<Integer> of(int value) {
        return new PrimitiveWrapper<Integer>(PhysicalType.INT32, value);
    }

    public static VariantPrimitive<Long> of(long value) {
        return new PrimitiveWrapper<Long>(PhysicalType.INT64, value);
    }

    public static VariantPrimitive<Float> of(float value) {
        return new PrimitiveWrapper<Float>(PhysicalType.FLOAT, Float.valueOf(value));
    }

    public static VariantPrimitive<Double> of(double value) {
        return new PrimitiveWrapper<Double>(PhysicalType.DOUBLE, value);
    }

    public static VariantPrimitive<Integer> ofDate(int value) {
        return new PrimitiveWrapper<Integer>(PhysicalType.DATE, value);
    }

    public static VariantPrimitive<Integer> ofIsoDate(String value) {
        return Variants.ofDate(DateTimeUtil.isoDateToDays((String)value));
    }

    public static VariantPrimitive<Long> ofTimestamptz(long value) {
        return new PrimitiveWrapper<Long>(PhysicalType.TIMESTAMPTZ, value);
    }

    public static VariantPrimitive<Long> ofIsoTimestamptz(String value) {
        return Variants.ofTimestamptz(DateTimeUtil.isoTimestamptzToMicros((String)value));
    }

    public static VariantPrimitive<Long> ofTimestampntz(long value) {
        return new PrimitiveWrapper<Long>(PhysicalType.TIMESTAMPNTZ, value);
    }

    public static VariantPrimitive<Long> ofIsoTimestampntz(String value) {
        return Variants.ofTimestampntz(DateTimeUtil.isoTimestampToMicros((String)value));
    }

    public static VariantPrimitive<BigDecimal> of(BigDecimal value) {
        int precision = value.precision();
        if (precision >= 1 && precision <= 9) {
            return new PrimitiveWrapper<BigDecimal>(PhysicalType.DECIMAL4, value);
        }
        if (precision >= 10 && precision <= 18) {
            return new PrimitiveWrapper<BigDecimal>(PhysicalType.DECIMAL8, value);
        }
        if (precision <= 38) {
            return new PrimitiveWrapper<BigDecimal>(PhysicalType.DECIMAL16, value);
        }
        throw new UnsupportedOperationException("Unsupported decimal precision: " + precision);
    }

    public static VariantPrimitive<ByteBuffer> of(ByteBuffer value) {
        return new PrimitiveWrapper<ByteBuffer>(PhysicalType.BINARY, value);
    }

    public static VariantPrimitive<String> of(String value) {
        return new PrimitiveWrapper<String>(PhysicalType.STRING, value);
    }

    public static VariantPrimitive<Long> ofTime(long value) {
        return new PrimitiveWrapper<Long>(PhysicalType.TIME, value);
    }

    public static VariantPrimitive<Long> ofIsoTime(String value) {
        return Variants.ofTime(DateTimeUtil.isoTimeToMicros((String)value));
    }

    public static VariantPrimitive<Long> ofTimestamptzNanos(long value) {
        return new PrimitiveWrapper<Long>(PhysicalType.TIMESTAMPTZ_NANOS, value);
    }

    public static VariantPrimitive<Long> ofIsoTimestamptzNanos(String value) {
        return Variants.ofTimestamptzNanos(DateTimeUtil.isoTimestamptzToNanos((CharSequence)value));
    }

    public static VariantPrimitive<Long> ofTimestampntzNanos(long value) {
        return new PrimitiveWrapper<Long>(PhysicalType.TIMESTAMPNTZ_NANOS, value);
    }

    public static VariantPrimitive<Long> ofIsoTimestampntzNanos(String value) {
        return Variants.ofTimestampntzNanos(DateTimeUtil.isoTimestampToNanos((CharSequence)value));
    }

    public static VariantPrimitive<UUID> ofUUID(UUID uuid) {
        return new PrimitiveWrapper<UUID>(PhysicalType.UUID, uuid);
    }

    public static VariantPrimitive<UUID> ofUUID(String uuid) {
        return Variants.ofUUID(UUID.fromString(uuid));
    }
}

