/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import java.time.OffsetDateTime;

public final class PathsUpdateHeaders {
    private String xMsVersion;
    private String contentRange;
    private DateTimeRfc1123 lastModified;
    private String xMsProperties;
    private String xMsStructuredBody;
    private String xMsContinuation;
    private DateTimeRfc1123 date;
    private String contentMD5;
    private String acceptRanges;
    private String cacheControl;
    private String eTag;
    private String contentDisposition;
    private String contentEncoding;
    private Long contentLength;
    private String xMsRequestId;
    private String contentLanguage;
    private String contentType;
    private static final HttpHeaderName X_MS_VERSION = HttpHeaderName.fromString((String)"x-ms-version");
    private static final HttpHeaderName X_MS_PROPERTIES = HttpHeaderName.fromString((String)"x-ms-properties");
    private static final HttpHeaderName X_MS_STRUCTURED_BODY = HttpHeaderName.fromString((String)"x-ms-structured-body");
    private static final HttpHeaderName X_MS_CONTINUATION = HttpHeaderName.fromString((String)"x-ms-continuation");

    public PathsUpdateHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue(X_MS_VERSION);
        this.contentRange = rawHeaders.getValue(HttpHeaderName.CONTENT_RANGE);
        String lastModified = rawHeaders.getValue(HttpHeaderName.LAST_MODIFIED);
        this.lastModified = lastModified != null ? new DateTimeRfc1123(lastModified) : null;
        this.xMsProperties = rawHeaders.getValue(X_MS_PROPERTIES);
        this.xMsStructuredBody = rawHeaders.getValue(X_MS_STRUCTURED_BODY);
        this.xMsContinuation = rawHeaders.getValue(X_MS_CONTINUATION);
        String date = rawHeaders.getValue(HttpHeaderName.DATE);
        this.date = date != null ? new DateTimeRfc1123(date) : null;
        this.contentMD5 = rawHeaders.getValue(HttpHeaderName.CONTENT_MD5);
        this.acceptRanges = rawHeaders.getValue(HttpHeaderName.ACCEPT_RANGES);
        this.cacheControl = rawHeaders.getValue(HttpHeaderName.CACHE_CONTROL);
        this.eTag = rawHeaders.getValue(HttpHeaderName.ETAG);
        this.contentDisposition = rawHeaders.getValue(HttpHeaderName.CONTENT_DISPOSITION);
        this.contentEncoding = rawHeaders.getValue(HttpHeaderName.CONTENT_ENCODING);
        String contentLength = rawHeaders.getValue(HttpHeaderName.CONTENT_LENGTH);
        this.contentLength = contentLength != null ? Long.valueOf(Long.parseLong(contentLength)) : null;
        this.xMsRequestId = rawHeaders.getValue(HttpHeaderName.X_MS_REQUEST_ID);
        this.contentLanguage = rawHeaders.getValue(HttpHeaderName.CONTENT_LANGUAGE);
        this.contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public PathsUpdateHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public PathsUpdateHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public PathsUpdateHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsProperties() {
        return this.xMsProperties;
    }

    public PathsUpdateHeaders setXMsProperties(String xMsProperties) {
        this.xMsProperties = xMsProperties;
        return this;
    }

    public String getXMsStructuredBody() {
        return this.xMsStructuredBody;
    }

    public PathsUpdateHeaders setXMsStructuredBody(String xMsStructuredBody) {
        this.xMsStructuredBody = xMsStructuredBody;
        return this;
    }

    public String getXMsContinuation() {
        return this.xMsContinuation;
    }

    public PathsUpdateHeaders setXMsContinuation(String xMsContinuation) {
        this.xMsContinuation = xMsContinuation;
        return this;
    }

    public OffsetDateTime getDate() {
        if (this.date == null) {
            return null;
        }
        return this.date.getDateTime();
    }

    public PathsUpdateHeaders setDate(OffsetDateTime date) {
        this.date = date == null ? null : new DateTimeRfc1123(date);
        return this;
    }

    public String getContentMD5() {
        return this.contentMD5;
    }

    public PathsUpdateHeaders setContentMD5(String contentMD5) {
        this.contentMD5 = contentMD5;
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public PathsUpdateHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public PathsUpdateHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public PathsUpdateHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public PathsUpdateHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public PathsUpdateHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public PathsUpdateHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public PathsUpdateHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public PathsUpdateHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public PathsUpdateHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }
}

