/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.common;

import jakarta.enterprise.inject.Instance;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.polaris.core.PolarisDiagnostics;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.catalog.ExternalCatalogFactory;
import org.apache.polaris.core.catalog.PolarisCatalogHelpers;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.credentials.PolarisCredentialManager;
import org.apache.polaris.core.entity.PolarisEntitySubType;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.resolver.PolarisResolutionManifest;
import org.apache.polaris.core.persistence.resolver.ResolutionManifestFactory;
import org.apache.polaris.core.persistence.resolver.ResolverPath;
import org.apache.polaris.core.persistence.resolver.ResolverStatus;
import org.apache.polaris.service.types.PolicyIdentifier;

public abstract class CatalogHandler {
    protected PolarisResolutionManifest resolutionManifest = null;
    protected final ResolutionManifestFactory resolutionManifestFactory;
    protected final String catalogName;
    protected final PolarisAuthorizer authorizer;
    protected final PolarisCredentialManager credentialManager;
    protected final Instance<ExternalCatalogFactory> externalCatalogFactories;
    protected final PolarisDiagnostics diagnostics;
    protected final CallContext callContext;
    protected final RealmConfig realmConfig;
    protected final PolarisPrincipal polarisPrincipal;

    public CatalogHandler(PolarisDiagnostics diagnostics, CallContext callContext, ResolutionManifestFactory resolutionManifestFactory, PolarisPrincipal principal, String catalogName, PolarisAuthorizer authorizer, PolarisCredentialManager credentialManager, Instance<ExternalCatalogFactory> externalCatalogFactories) {
        this.diagnostics = diagnostics;
        this.callContext = callContext;
        this.realmConfig = callContext.getRealmConfig();
        this.resolutionManifestFactory = resolutionManifestFactory;
        this.catalogName = catalogName;
        this.polarisPrincipal = principal;
        this.authorizer = authorizer;
        this.credentialManager = credentialManager;
        this.externalCatalogFactories = externalCatalogFactories;
    }

    protected PolarisCredentialManager getPolarisCredentialManager() {
        return this.credentialManager;
    }

    protected PolarisResolutionManifest newResolutionManifest() {
        return this.resolutionManifestFactory.createResolutionManifest(this.polarisPrincipal, this.catalogName);
    }

    protected abstract void initializeCatalog();

    protected void authorizeBasicNamespaceOperationOrThrow(PolarisAuthorizableOperation op, Namespace namespace) {
        this.authorizeBasicNamespaceOperationOrThrow(op, namespace, null, null, null);
    }

    protected void authorizeBasicNamespaceOperationOrThrow(PolarisAuthorizableOperation op, Namespace namespace, List<Namespace> extraPassthroughNamespaces, List<TableIdentifier> extraPassthroughTableLikes, List<PolicyIdentifier> extraPassThroughPolicies) {
        this.resolutionManifest = this.newResolutionManifest();
        this.resolutionManifest.addPath(new ResolverPath(Arrays.asList(namespace.levels()), PolarisEntityType.NAMESPACE), (Object)namespace);
        if (extraPassthroughNamespaces != null) {
            for (Namespace namespace2 : extraPassthroughNamespaces) {
                this.resolutionManifest.addPassthroughPath(new ResolverPath(Arrays.asList(namespace2.levels()), PolarisEntityType.NAMESPACE, true), (Object)namespace2);
            }
        }
        if (extraPassthroughTableLikes != null) {
            for (TableIdentifier tableIdentifier : extraPassthroughTableLikes) {
                this.resolutionManifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)tableIdentifier), PolarisEntityType.TABLE_LIKE, true), (Object)tableIdentifier);
            }
        }
        if (extraPassThroughPolicies != null) {
            for (PolicyIdentifier policyIdentifier : extraPassThroughPolicies) {
                this.resolutionManifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.identifierToList((Namespace)policyIdentifier.getNamespace(), (String)policyIdentifier.getName()), PolarisEntityType.POLICY, true), (Object)policyIdentifier);
            }
        }
        this.resolutionManifest.resolveAll();
        PolarisResolvedPathWrapper target = this.resolutionManifest.getResolvedPath((Object)namespace, true);
        if (target == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, target, null);
        this.initializeCatalog();
    }

    protected void authorizeCreateNamespaceUnderNamespaceOperationOrThrow(PolarisAuthorizableOperation op, Namespace namespace) {
        this.resolutionManifest = this.newResolutionManifest();
        Namespace parentNamespace = PolarisCatalogHelpers.getParentNamespace((Namespace)namespace);
        this.resolutionManifest.addPath(new ResolverPath(Arrays.asList(parentNamespace.levels()), PolarisEntityType.NAMESPACE), (Object)parentNamespace);
        this.resolutionManifest.addPassthroughPath(new ResolverPath(Arrays.asList(namespace.levels()), PolarisEntityType.NAMESPACE, true), (Object)namespace);
        this.resolutionManifest.resolveAll();
        PolarisResolvedPathWrapper target = this.resolutionManifest.getResolvedPath((Object)parentNamespace, true);
        if (target == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{parentNamespace});
        }
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, target, null);
        this.initializeCatalog();
    }

    protected void authorizeCreateTableLikeUnderNamespaceOperationOrThrow(PolarisAuthorizableOperation op, TableIdentifier identifier) {
        Namespace namespace = identifier.namespace();
        this.resolutionManifest = this.newResolutionManifest();
        this.resolutionManifest.addPath(new ResolverPath(Arrays.asList(namespace.levels()), PolarisEntityType.NAMESPACE), (Object)namespace);
        this.resolutionManifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)identifier), PolarisEntityType.TABLE_LIKE, true), (Object)identifier);
        this.resolutionManifest.resolveAll();
        PolarisResolvedPathWrapper target = this.resolutionManifest.getResolvedPath((Object)namespace, true);
        if (target == null) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{namespace});
        }
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, target, null);
        this.initializeCatalog();
    }

    protected void ensureResolutionManifestForTable(TableIdentifier identifier) {
        if (this.resolutionManifest == null) {
            this.resolutionManifest = this.newResolutionManifest();
            this.resolutionManifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)identifier), PolarisEntityType.TABLE_LIKE, true), (Object)identifier);
            this.resolutionManifest.resolveAll();
        }
    }

    protected void authorizeBasicTableLikeOperationOrThrow(PolarisAuthorizableOperation op, PolarisEntitySubType subType, TableIdentifier identifier) {
        this.authorizeBasicTableLikeOperationsOrThrow(EnumSet.of(op), subType, identifier);
    }

    protected void authorizeBasicTableLikeOperationsOrThrow(EnumSet<PolarisAuthorizableOperation> ops, PolarisEntitySubType subType, TableIdentifier identifier) {
        this.ensureResolutionManifestForTable(identifier);
        PolarisResolvedPathWrapper target = this.resolutionManifest.getResolvedPath((Object)identifier, PolarisEntityType.TABLE_LIKE, subType, true);
        if (target == null) {
            CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier, List.of(subType));
        }
        for (PolarisAuthorizableOperation op : ops) {
            this.authorizer.authorizeOrThrow(this.polarisPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, target, null);
        }
        this.initializeCatalog();
    }

    protected void authorizeCollectionOfTableLikeOperationOrThrow(PolarisAuthorizableOperation op, PolarisEntitySubType subType, List<TableIdentifier> ids) {
        this.resolutionManifest = this.newResolutionManifest();
        ids.forEach(identifier -> this.resolutionManifest.addPassthroughPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)identifier), PolarisEntityType.TABLE_LIKE), identifier));
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED) {
            TableIdentifier identifier2 = PolarisCatalogHelpers.listToTableIdentifier((List)status.getFailedToResolvePath().getEntityNames());
            CatalogHandler.throwNotFoundExceptionForTableLikeEntity(identifier2, List.of(subType));
        }
        List<PolarisResolvedPathWrapper> targets = ids.stream().map(identifier -> Optional.ofNullable(this.resolutionManifest.getResolvedPath(identifier, PolarisEntityType.TABLE_LIKE, subType, true)).orElseThrow(() -> subType == PolarisEntitySubType.ICEBERG_TABLE ? new NoSuchTableException("Table does not exist: %s", new Object[]{identifier}) : new NoSuchViewException("View does not exist: %s", new Object[]{identifier}))).toList();
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, targets, null);
        this.initializeCatalog();
    }

    protected void authorizeRenameTableLikeOperationOrThrow(PolarisAuthorizableOperation op, PolarisEntitySubType subType, TableIdentifier src, TableIdentifier dst) {
        this.resolutionManifest = this.newResolutionManifest();
        this.resolutionManifest.addPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)src), PolarisEntityType.TABLE_LIKE), (Object)src);
        this.resolutionManifest.addPath(new ResolverPath(Arrays.asList(dst.namespace().levels()), PolarisEntityType.NAMESPACE), (Object)dst.namespace());
        this.resolutionManifest.addPath(new ResolverPath(PolarisCatalogHelpers.tableIdentifierToList((TableIdentifier)dst), PolarisEntityType.TABLE_LIKE, true), (Object)dst);
        ResolverStatus status = this.resolutionManifest.resolveAll();
        if (status.getStatus() == ResolverStatus.StatusEnum.PATH_COULD_NOT_BE_FULLY_RESOLVED && status.getFailedToResolvePath().getLastEntityType() == PolarisEntityType.NAMESPACE) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", new Object[]{dst.namespace()});
        }
        if (this.resolutionManifest.getResolvedPath((Object)src, PolarisEntityType.TABLE_LIKE, subType) == null) {
            CatalogHandler.throwNotFoundExceptionForTableLikeEntity(dst, List.of(subType));
        }
        PolarisEntitySubType dstLeafSubType = this.resolutionManifest.getLeafSubType((Object)dst);
        switch (dstLeafSubType) {
            case ICEBERG_TABLE: {
                throw new AlreadyExistsException("Cannot rename %s to %s. Table already exists", new Object[]{src, dst});
            }
            case ICEBERG_VIEW: {
                throw new AlreadyExistsException("Cannot rename %s to %s. View already exists", new Object[]{src, dst});
            }
            case GENERIC_TABLE: {
                throw new AlreadyExistsException("Cannot rename %s to %s. Generic table already exists", new Object[]{src, dst});
            }
        }
        PolarisResolvedPathWrapper target = this.resolutionManifest.getResolvedPath((Object)src, PolarisEntityType.TABLE_LIKE, subType, true);
        PolarisResolvedPathWrapper secondary = this.resolutionManifest.getResolvedPath((Object)dst.namespace(), true);
        this.authorizer.authorizeOrThrow(this.polarisPrincipal, this.resolutionManifest.getAllActivatedCatalogRoleAndPrincipalRoles(), op, target, secondary);
        this.initializeCatalog();
    }

    public static void throwNotFoundExceptionForTableLikeEntity(TableIdentifier identifier, List<PolarisEntitySubType> subTypes) {
        if (subTypes.size() > 1) {
            throw new NoSuchTableException("Table does not exist: %s", new Object[]{identifier});
        }
        PolarisEntitySubType subType = subTypes.getFirst();
        switch (subType) {
            case ICEBERG_TABLE: {
                throw new NoSuchTableException("Table does not exist: %s", new Object[]{identifier});
            }
            case ICEBERG_VIEW: {
                throw new NoSuchViewException("View does not exist: %s", new Object[]{identifier});
            }
            case GENERIC_TABLE: {
                throw new NoSuchTableException("Generic table does not exist: %s", new Object[]{identifier});
            }
        }
        throw new NoSuchTableException("Table does not exist: %s", new Object[]{identifier});
    }
}

