/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.runtime.configuration.MemorySizeConverter;
import io.smallrye.config.WithConverter;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.iceberg.rest.RESTSerializers;
import org.apache.polaris.service.config.Serializers;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PolarisIcebergObjectMapperCustomizer
implements ObjectMapperCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisIcebergObjectMapperCustomizer.class);
    private final long maxBodySize;

    @Inject
    public PolarisIcebergObjectMapperCustomizer(@ConfigProperty(name="quarkus.http.limits.max-body-size") @WithConverter(value=MemorySizeConverter.class) MemorySize maxBodySize) {
        this.maxBodySize = maxBodySize.asLongValue();
    }

    public void customize(ObjectMapper objectMapper) {
        objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setPropertyNamingStrategy((PropertyNamingStrategy)new PropertyNamingStrategies.KebabCaseStrategy());
        RESTSerializers.registerAll((ObjectMapper)objectMapper);
        Serializers.registerSerializers(objectMapper);
        objectMapper.getFactory().setStreamReadConstraints(StreamReadConstraints.builder().maxDocumentLength(this.maxBodySize).build());
        LOGGER.info("Limiting request body size to {} bytes", (Object)this.maxBodySize);
    }
}

