/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.iceberg.expressions.BoundLiteralPredicate;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.BoundUnaryPredicate;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.base.Objects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.ProjectionUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.BinaryUtil;
import org.apache.iceberg.util.SerializableFunction;
import org.apache.iceberg.util.TruncateUtil;
import org.apache.iceberg.util.UnicodeUtil;

class Truncate<T>
implements Transform<T, T>,
Function<T, T> {
    protected final int width;

    static <T> Truncate<T> get(int width) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (String)"Invalid truncate width: %s (must be > 0)", (int)width);
        return new Truncate<T>(width);
    }

    @Deprecated
    static <T, R extends Truncate<T>> R get(Type type, int width) {
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0, (String)"Invalid truncate width: %s (must be > 0)", (int)width);
        switch (type.typeId()) {
            case INTEGER: {
                return (R)new TruncateInteger(width);
            }
            case LONG: {
                return (R)new TruncateLong(width);
            }
            case DECIMAL: {
                return (R)new TruncateDecimal(width);
            }
            case STRING: {
                return (R)new TruncateString(width);
            }
            case BINARY: {
                return (R)new TruncateByteBuffer(width);
            }
        }
        throw new UnsupportedOperationException("Cannot truncate type: " + String.valueOf(type));
    }

    Truncate(int width) {
        this.width = width;
    }

    public Integer width() {
        return this.width;
    }

    @Override
    public T apply(T value) {
        throw new UnsupportedOperationException("apply(value) is deprecated, use bind(Type).apply(value)");
    }

    @Override
    public SerializableFunction<T, T> bind(Type type) {
        Preconditions.checkArgument((boolean)this.canTransform(type), (String)"Cannot bind to unsupported type: %s", (Object)type);
        return (SerializableFunction)Truncate.get(type, this.width);
    }

    @Override
    public boolean canTransform(Type type) {
        switch (type.typeId()) {
            case INTEGER: 
            case LONG: 
            case DECIMAL: 
            case STRING: 
            case BINARY: {
                return true;
            }
        }
        return false;
    }

    @Override
    public UnboundPredicate<T> project(String name, BoundPredicate<T> predicate) {
        Object bound = Truncate.get(((BoundTerm)predicate.term()).type(), this.width);
        return ((Truncate)bound).project(name, predicate);
    }

    @Override
    public UnboundPredicate<T> projectStrict(String name, BoundPredicate<T> predicate) {
        Object bound = Truncate.get(((BoundTerm)predicate.term()).type(), this.width);
        return ((Truncate)bound).projectStrict(name, predicate);
    }

    @Override
    public Type getResultType(Type sourceType) {
        return sourceType;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Truncate)) {
            return false;
        }
        Truncate otherTrunc = (Truncate)other;
        return otherTrunc.width <= this.width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Truncate)) {
            return false;
        }
        Truncate that = (Truncate)o;
        return this.width == that.width;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.width});
    }

    public String toString() {
        return "truncate[" + this.width + "]";
    }

    private static class TruncateInteger
    extends Truncate<Integer>
    implements SerializableFunction<Integer, Integer> {
        private TruncateInteger(int width) {
            super(width);
        }

        @Override
        public SerializableFunction<Integer, Integer> bind(Type type) {
            Preconditions.checkArgument((type.typeId() == Type.TypeID.INTEGER ? 1 : 0) != 0, (String)"Cannot bind truncate to a different type: %s", (Object)type);
            return this;
        }

        @Override
        public Integer apply(Integer value) {
            if (value == null) {
                return null;
            }
            return TruncateUtil.truncateInt(this.width, value);
        }

        @Override
        public UnboundPredicate<Integer> project(String name, BoundPredicate<Integer> pred) {
            if (pred.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, pred);
            }
            if (pred.isUnaryPredicate()) {
                return Expressions.predicate(pred.op(), name);
            }
            if (pred.isLiteralPredicate()) {
                return ProjectionUtil.truncateInteger(name, pred.asLiteralPredicate(), this);
            }
            if (pred.isSetPredicate() && pred.op() == Expression.Operation.IN) {
                return ProjectionUtil.transformSet(name, pred.asSetPredicate(), this);
            }
            return null;
        }

        @Override
        public UnboundPredicate<Integer> projectStrict(String name, BoundPredicate<Integer> pred) {
            if (pred.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, pred);
            }
            if (pred instanceof BoundUnaryPredicate) {
                return Expressions.predicate(pred.op(), name);
            }
            if (pred instanceof BoundLiteralPredicate) {
                return ProjectionUtil.truncateIntegerStrict(name, pred.asLiteralPredicate(), this);
            }
            if (pred.isSetPredicate() && pred.op() == Expression.Operation.NOT_IN) {
                return ProjectionUtil.transformSet(name, pred.asSetPredicate(), this);
            }
            return null;
        }
    }

    private static class TruncateLong
    extends Truncate<Long>
    implements SerializableFunction<Long, Long> {
        private TruncateLong(int width) {
            super(width);
        }

        @Override
        public SerializableFunction<Long, Long> bind(Type type) {
            Preconditions.checkArgument((type.typeId() == Type.TypeID.LONG ? 1 : 0) != 0, (String)"Cannot bind truncate to a different type: %s", (Object)type);
            return this;
        }

        @Override
        public Long apply(Long value) {
            if (value == null) {
                return null;
            }
            return TruncateUtil.truncateLong(this.width, value);
        }

        @Override
        public UnboundPredicate<Long> project(String name, BoundPredicate<Long> pred) {
            if (pred.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, pred);
            }
            if (pred.isUnaryPredicate()) {
                return Expressions.predicate(pred.op(), name);
            }
            if (pred.isLiteralPredicate()) {
                return ProjectionUtil.truncateLong(name, pred.asLiteralPredicate(), this);
            }
            if (pred.isSetPredicate() && pred.op() == Expression.Operation.IN) {
                return ProjectionUtil.transformSet(name, pred.asSetPredicate(), this);
            }
            return null;
        }

        @Override
        public UnboundPredicate<Long> projectStrict(String name, BoundPredicate<Long> pred) {
            if (pred.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, pred);
            }
            if (pred.isUnaryPredicate()) {
                return Expressions.predicate(pred.op(), name);
            }
            if (pred.isLiteralPredicate()) {
                return ProjectionUtil.truncateLongStrict(name, pred.asLiteralPredicate(), this);
            }
            if (pred.isSetPredicate() && pred.op() == Expression.Operation.NOT_IN) {
                return ProjectionUtil.transformSet(name, pred.asSetPredicate(), this);
            }
            return null;
        }
    }

    private static class TruncateDecimal
    extends Truncate<BigDecimal>
    implements SerializableFunction<BigDecimal, BigDecimal> {
        private final BigInteger unscaledWidth;

        private TruncateDecimal(int unscaledWidth) {
            super(unscaledWidth);
            this.unscaledWidth = BigInteger.valueOf(unscaledWidth);
        }

        @Override
        public SerializableFunction<BigDecimal, BigDecimal> bind(Type type) {
            Preconditions.checkArgument((type.typeId() == Type.TypeID.DECIMAL ? 1 : 0) != 0, (String)"Cannot bind truncate to a different type: %s", (Object)type);
            return this;
        }

        @Override
        public BigDecimal apply(BigDecimal value) {
            if (value == null) {
                return null;
            }
            return TruncateUtil.truncateDecimal(this.unscaledWidth, value);
        }

        @Override
        public UnboundPredicate<BigDecimal> project(String name, BoundPredicate<BigDecimal> pred) {
            if (pred.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, pred);
            }
            if (pred.isUnaryPredicate()) {
                return Expressions.predicate(pred.op(), name);
            }
            if (pred.isLiteralPredicate()) {
                return ProjectionUtil.truncateDecimal(name, pred.asLiteralPredicate(), this);
            }
            if (pred.isSetPredicate() && pred.op() == Expression.Operation.IN) {
                return ProjectionUtil.transformSet(name, pred.asSetPredicate(), this);
            }
            return null;
        }

        @Override
        public UnboundPredicate<BigDecimal> projectStrict(String name, BoundPredicate<BigDecimal> pred) {
            if (pred.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, pred);
            }
            if (pred.isUnaryPredicate()) {
                return Expressions.predicate(pred.op(), name);
            }
            if (pred.isLiteralPredicate()) {
                return ProjectionUtil.truncateDecimalStrict(name, pred.asLiteralPredicate(), this);
            }
            if (pred.isSetPredicate() && pred.op() == Expression.Operation.NOT_IN) {
                return ProjectionUtil.transformSet(name, pred.asSetPredicate(), this);
            }
            return null;
        }
    }

    private static class TruncateString
    extends Truncate<CharSequence>
    implements SerializableFunction<CharSequence, CharSequence> {
        private TruncateString(int length) {
            super(length);
        }

        @Override
        public SerializableFunction<CharSequence, CharSequence> bind(Type type) {
            Preconditions.checkArgument((type.typeId() == Type.TypeID.STRING ? 1 : 0) != 0, (String)"Cannot bind truncate to a different type: %s", (Object)type);
            return this;
        }

        @Override
        public CharSequence apply(CharSequence value) {
            if (value == null) {
                return null;
            }
            return UnicodeUtil.truncateString(value, this.width);
        }

        @Override
        public boolean satisfiesOrderOf(Transform<?, ?> other) {
            if (this == other) {
                return true;
            }
            if (other instanceof TruncateString) {
                TruncateString otherTransform = (TruncateString)other;
                return this.width() >= otherTransform.width();
            }
            return false;
        }

        @Override
        public UnboundPredicate<CharSequence> project(String name, BoundPredicate<CharSequence> predicate) {
            if (predicate.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, predicate);
            }
            if (predicate.isUnaryPredicate()) {
                return Expressions.predicate(predicate.op(), name);
            }
            if (predicate.isLiteralPredicate()) {
                BoundLiteralPredicate<CharSequence> pred = predicate.asLiteralPredicate();
                switch (pred.op()) {
                    case STARTS_WITH: {
                        if (pred.literal().value().length() < this.width()) {
                            return Expressions.predicate(pred.op(), name, pred.literal().value());
                        }
                        if (pred.literal().value().length() == this.width().intValue()) {
                            return Expressions.equal(name, pred.literal().value());
                        }
                        return ProjectionUtil.truncateArray(name, pred, this);
                    }
                    case NOT_STARTS_WITH: {
                        if (pred.literal().value().length() < this.width()) {
                            return Expressions.predicate(pred.op(), name, pred.literal().value());
                        }
                        if (pred.literal().value().length() == this.width().intValue()) {
                            return Expressions.notEqual(name, pred.literal().value());
                        }
                        return null;
                    }
                }
                return ProjectionUtil.truncateArray(name, pred, this);
            }
            if (predicate.isSetPredicate() && predicate.op() == Expression.Operation.IN) {
                return ProjectionUtil.transformSet(name, predicate.asSetPredicate(), this);
            }
            return null;
        }

        @Override
        public UnboundPredicate<CharSequence> projectStrict(String name, BoundPredicate<CharSequence> predicate) {
            if (predicate.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, predicate);
            }
            if (predicate instanceof BoundUnaryPredicate) {
                return Expressions.predicate(predicate.op(), name);
            }
            if (predicate instanceof BoundLiteralPredicate) {
                BoundLiteralPredicate<CharSequence> pred = predicate.asLiteralPredicate();
                switch (pred.op()) {
                    case STARTS_WITH: {
                        if (pred.literal().value().length() < this.width()) {
                            return Expressions.predicate(pred.op(), name, pred.literal().value());
                        }
                        if (pred.literal().value().length() == this.width().intValue()) {
                            return Expressions.equal(name, pred.literal().value());
                        }
                        return null;
                    }
                    case NOT_STARTS_WITH: {
                        if (pred.literal().value().length() < this.width()) {
                            return Expressions.predicate(pred.op(), name, pred.literal().value());
                        }
                        if (pred.literal().value().length() == this.width().intValue()) {
                            return Expressions.notEqual(name, pred.literal().value());
                        }
                        return Expressions.predicate(pred.op(), name, this.apply(pred.literal().value()).toString());
                    }
                }
                return ProjectionUtil.truncateArrayStrict(name, pred, this);
            }
            if (predicate.isSetPredicate() && predicate.op() == Expression.Operation.NOT_IN) {
                return ProjectionUtil.transformSet(name, predicate.asSetPredicate(), this);
            }
            return null;
        }
    }

    private static class TruncateByteBuffer
    extends Truncate<ByteBuffer>
    implements SerializableFunction<ByteBuffer, ByteBuffer> {
        private TruncateByteBuffer(int length) {
            super(length);
        }

        @Override
        public SerializableFunction<ByteBuffer, ByteBuffer> bind(Type type) {
            Preconditions.checkArgument((type.typeId() == Type.TypeID.BINARY || type.typeId() == Type.TypeID.FIXED ? 1 : 0) != 0, (String)"Cannot bind truncate to a different type: %s", (Object)type);
            return this;
        }

        @Override
        public ByteBuffer apply(ByteBuffer value) {
            if (value == null) {
                return null;
            }
            return BinaryUtil.truncateBinaryUnsafe(value, this.width);
        }

        @Override
        public UnboundPredicate<ByteBuffer> project(String name, BoundPredicate<ByteBuffer> pred) {
            if (pred.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, pred);
            }
            if (pred.isUnaryPredicate()) {
                return Expressions.predicate(pred.op(), name);
            }
            if (pred.isLiteralPredicate()) {
                return ProjectionUtil.truncateArray(name, pred.asLiteralPredicate(), this);
            }
            if (pred.isSetPredicate() && pred.op() == Expression.Operation.IN) {
                return ProjectionUtil.transformSet(name, pred.asSetPredicate(), this);
            }
            return null;
        }

        @Override
        public UnboundPredicate<ByteBuffer> projectStrict(String name, BoundPredicate<ByteBuffer> pred) {
            if (pred.term() instanceof BoundTransform) {
                return ProjectionUtil.projectTransformPredicate(this, name, pred);
            }
            if (pred.isUnaryPredicate()) {
                return Expressions.predicate(pred.op(), name);
            }
            if (pred.isLiteralPredicate()) {
                return ProjectionUtil.truncateArrayStrict(name, pred.asLiteralPredicate(), this);
            }
            if (pred.isSetPredicate() && pred.op() == Expression.Operation.NOT_IN) {
                return ProjectionUtil.transformSet(name, pred.asSetPredicate(), this);
            }
            return null;
        }
    }
}

