/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.polaris.core.config.RealmConfig;
import org.apache.polaris.core.storage.InMemoryStorageIntegration;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.PolarisStorageConfigurationInfo;
import org.apache.polaris.core.storage.PolarisStorageIntegration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationRestrictions {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationRestrictions.class);
    private final List<String> allowedLocations;
    private final String parentLocation;

    public LocationRestrictions(@Nonnull PolarisStorageConfigurationInfo storageConfigurationInfo, String parentLocation) {
        this.allowedLocations = storageConfigurationInfo.getAllowedLocations();
        this.allowedLocations.forEach(storageConfigurationInfo::validatePrefixForStorageType);
        this.parentLocation = parentLocation;
    }

    public LocationRestrictions(@Nonnull PolarisStorageConfigurationInfo storageConfigurationInfo) {
        this(storageConfigurationInfo, null);
    }

    public void validate(RealmConfig realmConfig, TableIdentifier identifier, Set<String> requestLocations) {
        if (this.parentLocation != null) {
            this.validateLocations(realmConfig, List.of(this.parentLocation), requestLocations, identifier);
        }
        this.validateLocations(realmConfig, this.allowedLocations, requestLocations, identifier);
    }

    private void validateLocations(RealmConfig realmConfig, List<String> allowedLocations, Set<String> requestLocations, TableIdentifier identifier) {
        Map<String, Map<PolarisStorageActions, PolarisStorageIntegration.ValidationResult>> validationResults = InMemoryStorageIntegration.validateAllowedLocations(realmConfig, allowedLocations, Set.of(PolarisStorageActions.ALL), requestLocations);
        validationResults.values().forEach(actionResult -> actionResult.values().forEach(result -> {
            if (!result.isSuccess()) {
                throw new ForbiddenException("Invalid locations '%s' for identifier '%s': %s", new Object[]{requestLocations, identifier, result.getMessage()});
            }
            LOGGER.debug("Validated locations '{}' for identifier '{}'", (Object)requestLocations, (Object)identifier);
        }));
    }
}

