/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build;

import io.smallrye.jwt.build.JwtEncryptionBuilder;
import io.smallrye.jwt.build.JwtSignature;
import io.smallrye.jwt.build.JwtSignatureBuilder;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claims;

public interface JwtClaimsBuilder
extends JwtSignature {
    public JwtClaimsBuilder issuer(String var1);

    public JwtClaimsBuilder subject(String var1);

    public JwtClaimsBuilder upn(String var1);

    public JwtClaimsBuilder preferredUserName(String var1);

    public JwtClaimsBuilder issuedAt(long var1);

    default public JwtClaimsBuilder issuedAt(Instant issuedAt) {
        return this.issuedAt(issuedAt.getEpochSecond());
    }

    public JwtClaimsBuilder expiresAt(long var1);

    default public JwtClaimsBuilder expiresAt(Instant expiresAt) {
        return this.expiresAt(expiresAt.getEpochSecond());
    }

    public JwtClaimsBuilder expiresIn(long var1);

    default public JwtClaimsBuilder expiresIn(Duration expiresIn) {
        return this.expiresIn(expiresIn.getSeconds());
    }

    default public JwtClaimsBuilder groups(String group) {
        return this.groups(Set.of(group));
    }

    public JwtClaimsBuilder groups(Set<String> var1);

    default public JwtClaimsBuilder scope(String scope) {
        return this.scope(Set.of(scope));
    }

    public JwtClaimsBuilder scope(Set<String> var1);

    public JwtClaimsBuilder audience(String var1);

    public JwtClaimsBuilder audience(Set<String> var1);

    default public JwtClaimsBuilder claim(Claims name, Object value) {
        return this.claim(name.name(), value);
    }

    public JwtClaimsBuilder claim(String var1, Object var2);

    public JwtClaimsBuilder remove(String var1);

    public JwtSignatureBuilder jws();

    public JwtEncryptionBuilder jwe();
}

