/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.async.listener.PublisherListener;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.s3.S3FinishedResponseContext;
import software.amazon.awssdk.crt.s3.S3MetaRequestProgress;
import software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandler;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.services.s3.internal.crt.S3MetaRequestWrapper;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkInternalApi
public final class S3CrtResponseHandlerAdapter
implements S3MetaRequestResponseHandler {
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(S3CrtResponseHandlerAdapter.class);
    private static final Duration META_REQUEST_TIMEOUT = Duration.ofSeconds(10L);
    private final CompletableFuture<Void> resultFuture;
    private final SdkAsyncHttpResponseHandler responseHandler;
    private final SimplePublisher<ByteBuffer> responsePublisher = new SimplePublisher();
    private final SdkHttpResponse.Builder initialHeadersResponse = SdkHttpResponse.builder();
    private final CompletableFuture<S3MetaRequestWrapper> metaRequestFuture;
    private final PublisherListener<S3MetaRequestProgress> progressListener;
    private final Duration s3MetaRequestTimeout;
    private volatile boolean responseHandlingInitiated;

    public S3CrtResponseHandlerAdapter(CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler, PublisherListener<S3MetaRequestProgress> progressListener, CompletableFuture<S3MetaRequestWrapper> metaRequestFuture) {
        this(executeFuture, responseHandler, progressListener, metaRequestFuture, META_REQUEST_TIMEOUT);
    }

    @SdkTestInternalApi
    public S3CrtResponseHandlerAdapter(CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler, PublisherListener<S3MetaRequestProgress> progressListener, CompletableFuture<S3MetaRequestWrapper> metaRequestFuture, Duration s3MetaRequestTimeout) {
        this.resultFuture = executeFuture;
        this.metaRequestFuture = metaRequestFuture;
        this.resultFuture.whenComplete((r, t) -> {
            S3MetaRequestWrapper s3MetaRequest = this.s3MetaRequest();
            if (s3MetaRequest == null) {
                return;
            }
            if (t != null) {
                s3MetaRequest.cancel();
            }
            s3MetaRequest.close();
        });
        this.responseHandler = responseHandler;
        this.progressListener = progressListener == null ? new NoOpPublisherListener() : progressListener;
        this.s3MetaRequestTimeout = s3MetaRequestTimeout;
    }

    private S3MetaRequestWrapper s3MetaRequest() {
        try {
            return this.metaRequestFuture.get(this.s3MetaRequestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            this.failResponseHandlerAndFuture(new RuntimeException("Timeout waiting for metaRequest to be ready", e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.failResponseHandlerAndFuture(new RuntimeException(e));
        }
        return null;
    }

    public void onResponseHeaders(int statusCode, HttpHeader[] headers) {
        log.debug(() -> "Received response header with status code " + statusCode);
        S3CrtResponseHandlerAdapter.populateSdkHttpResponse(this.initialHeadersResponse, statusCode, headers);
    }

    public int onResponseBody(ByteBuffer bodyBytesIn, long objectRangeStart, long objectRangeEnd) {
        this.initiateResponseHandling((SdkHttpResponse)this.initialHeadersResponse.build());
        if (bodyBytesIn == null) {
            this.failResponseHandlerAndFuture(new IllegalStateException("ByteBuffer delivered is null"));
            return 0;
        }
        int bytesReceived = bodyBytesIn.remaining();
        CompletableFuture writeFuture = this.responsePublisher.send((Object)bodyBytesIn);
        writeFuture.whenComplete((result, failure) -> {
            if (failure != null) {
                this.failResponseHandlerAndFuture((Throwable)failure);
                return;
            }
            S3MetaRequestWrapper metaRequest = this.s3MetaRequest();
            if (metaRequest == null) {
                return;
            }
            metaRequest.incrementReadWindow(bytesReceived);
        });
        return 0;
    }

    public void onFinished(S3FinishedResponseContext context) {
        int crtCode = context.getErrorCode();
        log.debug(() -> "Request finished with code: " + crtCode);
        if (crtCode != 0) {
            this.handleError(context);
        } else {
            this.initiateResponseHandling((SdkHttpResponse)this.initialHeadersResponse.build());
            this.onSuccessfulResponseComplete();
        }
    }

    private void onSuccessfulResponseComplete() {
        this.responsePublisher.complete().whenComplete((result, failure) -> {
            if (failure != null) {
                this.failResponseHandlerAndFuture((Throwable)failure);
                return;
            }
            this.progressListener.subscriberOnComplete();
            this.resultFuture.complete(null);
        });
    }

    private void handleError(S3FinishedResponseContext context) {
        int crtCode = context.getErrorCode();
        HttpHeader[] headers = context.getErrorHeaders();
        int responseStatus = context.getResponseStatus();
        byte[] errorPayload = context.getErrorPayload();
        if (S3CrtResponseHandlerAdapter.isServiceError(responseStatus) && errorPayload != null) {
            this.handleServiceError(responseStatus, headers, errorPayload);
        } else {
            this.handleIoError(context, crtCode);
        }
    }

    private void handleIoError(S3FinishedResponseContext context, int crtCode) {
        Throwable cause = context.getCause();
        SdkClientException sdkClientException = SdkClientException.create((String)("Failed to send the request: " + CRT.awsErrorString((int)crtCode)), (Throwable)cause);
        this.failResponseHandlerAndFuture((Throwable)sdkClientException);
        this.notifyResponsePublisherErrorIfNeeded((Throwable)sdkClientException);
    }

    private void notifyResponsePublisherErrorIfNeeded(Throwable error) {
        if (this.responseHandlingInitiated) {
            this.responsePublisher.error(error).handle((ignore, throwable) -> {
                if (throwable != null) {
                    log.warn(() -> "Exception thrown in responsePublisher#error, ignoring", throwable);
                    return null;
                }
                return null;
            });
        }
    }

    private void handleServiceError(int responseStatus, HttpHeader[] headers, byte[] errorPayload) {
        SdkHttpResponse.Builder errorResponse = S3CrtResponseHandlerAdapter.populateSdkHttpResponse((SdkHttpResponse.Builder)SdkHttpResponse.builder(), responseStatus, headers);
        if (this.requestFailedMidwayOfOtherError(responseStatus)) {
            AwsServiceException s3Exception = S3CrtResponseHandlerAdapter.buildS3Exception(responseStatus, errorPayload, errorResponse);
            SdkClientException sdkClientException = SdkClientException.create((String)"Request failed during the transfer due to an error returned from S3");
            s3Exception.addSuppressed((Throwable)sdkClientException);
            this.failResponseHandlerAndFuture((Throwable)s3Exception);
            this.notifyResponsePublisherErrorIfNeeded((Throwable)s3Exception);
        } else {
            this.initiateResponseHandling((SdkHttpResponse)errorResponse.build());
            this.onErrorResponseComplete(errorPayload);
        }
    }

    private static AwsServiceException buildS3Exception(int responseStatus, byte[] errorPayload, SdkHttpResponse.Builder errorResponse) {
        String requestId = errorResponse.firstMatchingHeader("x-amz-request-id").orElse(null);
        String extendedRequestId = errorResponse.firstMatchingHeader("x-amz-id-2").orElse(null);
        return S3Exception.builder().requestId(requestId).extendedRequestId(extendedRequestId).statusCode(responseStatus).message(errorResponse.statusText()).awsErrorDetails(AwsErrorDetails.builder().sdkHttpResponse((SdkHttpResponse)errorResponse.build()).rawResponse(SdkBytes.fromByteArray((byte[])errorPayload)).build()).build();
    }

    private boolean requestFailedMidwayOfOtherError(int responseStatus) {
        return this.responseHandlingInitiated && this.initialHeadersResponse.statusCode() != responseStatus;
    }

    private void initiateResponseHandling(SdkHttpResponse response) {
        if (!this.responseHandlingInitiated) {
            this.responseHandlingInitiated = true;
            this.responseHandler.onHeaders(response);
            this.responseHandler.onStream(this.responsePublisher);
        }
    }

    private void onErrorResponseComplete(byte[] errorPayload) {
        ((CompletableFuture)this.responsePublisher.send((Object)ByteBuffer.wrap(errorPayload)).thenRun(() -> this.responsePublisher.complete())).handle((ignore, throwable) -> {
            if (throwable != null) {
                this.failResponseHandlerAndFuture((Throwable)throwable);
                return null;
            }
            this.resultFuture.complete(null);
            return null;
        });
    }

    private void failResponseHandlerAndFuture(Throwable exception) {
        FunctionalUtils.runAndLogError((Logger)log.logger(), (String)"Exception thrown in SdkAsyncHttpResponseHandler#onError, ignoring", () -> this.responseHandler.onError(exception));
        this.resultFuture.completeExceptionally(exception);
    }

    private static boolean isServiceError(int responseStatus) {
        return responseStatus != 0;
    }

    public void onProgress(S3MetaRequestProgress progress) {
        this.progressListener.subscriberOnNext((Object)progress);
    }

    private static SdkHttpResponse.Builder populateSdkHttpResponse(SdkHttpResponse.Builder respBuilder, int statusCode, HttpHeader[] headers) {
        if (headers != null) {
            for (HttpHeader h : headers) {
                respBuilder.appendHeader(h.getName(), h.getValue());
            }
        }
        respBuilder.statusCode(statusCode);
        return respBuilder;
    }

    private static class NoOpPublisherListener
    implements PublisherListener<S3MetaRequestProgress> {
        private NoOpPublisherListener() {
        }
    }
}

