/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.util.Set;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTerm;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class BoundSetPredicate<T>
extends BoundPredicate<T> {
    private static final Joiner COMMA = Joiner.on((String)", ");
    private final Set<T> literalSet;

    BoundSetPredicate(Expression.Operation op, BoundTerm<T> term, Set<T> lits) {
        super(op, term);
        Preconditions.checkArgument((op == Expression.Operation.IN || op == Expression.Operation.NOT_IN ? 1 : 0) != 0, (String)"%s predicate does not support a literal set", (Object)((Object)op));
        this.literalSet = lits;
    }

    @Override
    public Expression negate() {
        return new BoundSetPredicate<T>(this.op().negate(), (BoundTerm)this.term(), this.literalSet);
    }

    @Override
    public boolean isSetPredicate() {
        return true;
    }

    @Override
    public BoundSetPredicate<T> asSetPredicate() {
        return this;
    }

    public Set<T> literalSet() {
        return this.literalSet;
    }

    @Override
    public boolean test(T value) {
        switch (this.op()) {
            case IN: {
                return this.literalSet.contains(value);
            }
            case NOT_IN: {
                return !this.literalSet.contains(value);
            }
        }
        throw new IllegalStateException("Invalid operation for BoundSetPredicate: " + String.valueOf((Object)this.op()));
    }

    @Override
    public boolean isEquivalentTo(Expression other) {
        if (this.op() == other.op()) {
            BoundSetPredicate pred = (BoundSetPredicate)other;
            return this.literalSet().equals(pred.literalSet());
        }
        return false;
    }

    public String toString() {
        switch (this.op()) {
            case IN: {
                return String.valueOf(this.term()) + " in (" + COMMA.join(this.literalSet) + ")";
            }
            case NOT_IN: {
                return String.valueOf(this.term()) + " not in (" + COMMA.join(this.literalSet) + ")";
            }
        }
        return "Invalid unary predicate: operation = " + String.valueOf((Object)this.op());
    }
}

