/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public abstract class SchemaWithPartnerVisitor<P, R> {
    public static <P, T> T visit(Schema schema, P partner, SchemaWithPartnerVisitor<P, T> visitor, PartnerAccessors<P> accessors) {
        return visitor.schema(schema, partner, SchemaWithPartnerVisitor.visit((Type)schema.asStruct(), partner, visitor, accessors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <P, T> T visit(Type type, P partner, SchemaWithPartnerVisitor<P, T> visitor, PartnerAccessors<P> accessors) {
        switch (type.typeId()) {
            case STRUCT: {
                Types.StructType struct = type.asNestedType().asStructType();
                ArrayList results = Lists.newArrayListWithExpectedSize((int)struct.fields().size());
                for (Types.NestedField field : struct.fields()) {
                    T result;
                    P fieldPartner = partner != null ? (P)accessors.fieldPartner(partner, field.fieldId(), field.name()) : null;
                    visitor.beforeField(field, fieldPartner);
                    try {
                        result = SchemaWithPartnerVisitor.visit(field.type(), fieldPartner, visitor, accessors);
                    }
                    finally {
                        visitor.afterField(field, fieldPartner);
                    }
                    results.add(visitor.field(field, fieldPartner, result));
                }
                return visitor.struct(struct, partner, results);
            }
            case LIST: {
                T elementResult;
                Types.ListType list = type.asNestedType().asListType();
                Types.NestedField elementField = list.field(list.elementId());
                P partnerElement = partner != null ? (P)accessors.listElementPartner(partner) : null;
                visitor.beforeListElement(elementField, partnerElement);
                try {
                    elementResult = SchemaWithPartnerVisitor.visit(list.elementType(), partnerElement, visitor, accessors);
                }
                finally {
                    visitor.afterListElement(elementField, partnerElement);
                }
                return visitor.list(list, partner, elementResult);
            }
            case MAP: {
                T valueResult;
                T keyResult;
                Types.MapType map = type.asNestedType().asMapType();
                Types.NestedField keyField = map.field(map.keyId());
                P keyPartner = partner != null ? (P)accessors.mapKeyPartner(partner) : null;
                visitor.beforeMapKey(keyField, keyPartner);
                try {
                    keyResult = SchemaWithPartnerVisitor.visit(map.keyType(), keyPartner, visitor, accessors);
                }
                finally {
                    visitor.afterMapKey(keyField, keyPartner);
                }
                Types.NestedField valueField = map.field(map.valueId());
                P valuePartner = partner != null ? (P)accessors.mapValuePartner(partner) : null;
                visitor.beforeMapValue(valueField, valuePartner);
                try {
                    valueResult = SchemaWithPartnerVisitor.visit(map.valueType(), valuePartner, visitor, accessors);
                }
                finally {
                    visitor.afterMapValue(valueField, valuePartner);
                }
                return visitor.map(map, partner, keyResult, valueResult);
            }
            case VARIANT: {
                return visitor.variant(type.asVariantType(), partner);
            }
        }
        return visitor.primitive(type.asPrimitiveType(), partner);
    }

    public void beforeField(Types.NestedField field, P partnerField) {
    }

    public void afterField(Types.NestedField field, P partnerField) {
    }

    public void beforeListElement(Types.NestedField elementField, P partnerField) {
        this.beforeField(elementField, partnerField);
    }

    public void afterListElement(Types.NestedField elementField, P partnerField) {
        this.afterField(elementField, partnerField);
    }

    public void beforeMapKey(Types.NestedField keyField, P partnerField) {
        this.beforeField(keyField, partnerField);
    }

    public void afterMapKey(Types.NestedField keyField, P partnerField) {
        this.afterField(keyField, partnerField);
    }

    public void beforeMapValue(Types.NestedField valueField, P partnerField) {
        this.beforeField(valueField, partnerField);
    }

    public void afterMapValue(Types.NestedField valueField, P partnerField) {
        this.afterField(valueField, partnerField);
    }

    public R schema(Schema schema, P partner, R structResult) {
        return null;
    }

    public R struct(Types.StructType struct, P partner, List<R> fieldResults) {
        return null;
    }

    public R field(Types.NestedField field, P partner, R fieldResult) {
        return null;
    }

    public R list(Types.ListType list, P partner, R elementResult) {
        return null;
    }

    public R map(Types.MapType map, P partner, R keyResult, R valueResult) {
        return null;
    }

    public R variant(Types.VariantType variant, P partner) {
        throw new UnsupportedOperationException("Unsupported type: variant");
    }

    public R primitive(Type.PrimitiveType primitive, P partner) {
        return null;
    }

    public static interface PartnerAccessors<P> {
        public P fieldPartner(P var1, int var2, String var3);

        public P mapKeyPartner(P var1);

        public P mapValuePartner(P var1);

        public P listElementPartner(P var1);
    }
}

