/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.iceberg.exceptions.ForbiddenException;
import org.apache.polaris.core.auth.PolarisAuthorizableOperation;
import org.apache.polaris.core.auth.PolarisAuthorizer;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.apache.polaris.extension.auth.opa.model.ImmutableActor;
import org.apache.polaris.extension.auth.opa.model.ImmutableContext;
import org.apache.polaris.extension.auth.opa.model.ImmutableOpaAuthorizationInput;
import org.apache.polaris.extension.auth.opa.model.ImmutableOpaRequest;
import org.apache.polaris.extension.auth.opa.model.ImmutableResource;
import org.apache.polaris.extension.auth.opa.model.ImmutableResourceEntity;
import org.apache.polaris.extension.auth.opa.model.ResourceEntity;
import org.apache.polaris.extension.auth.opa.token.BearerTokenProvider;

class OpaPolarisAuthorizer
implements PolarisAuthorizer {
    private final URI policyUri;
    private final BearerTokenProvider tokenProvider;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public OpaPolarisAuthorizer(@Nonnull URI policyUri, @Nonnull CloseableHttpClient httpClient, @Nonnull ObjectMapper objectMapper, @Nullable BearerTokenProvider tokenProvider) {
        this.policyUri = policyUri;
        this.tokenProvider = tokenProvider;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper;
    }

    public void authorizeOrThrow(@Nonnull PolarisPrincipal polarisPrincipal, @Nonnull Set<PolarisBaseEntity> activatedEntities, @Nonnull PolarisAuthorizableOperation authzOp, @Nullable PolarisResolvedPathWrapper target, @Nullable PolarisResolvedPathWrapper secondary) {
        this.authorizeOrThrow(polarisPrincipal, activatedEntities, authzOp, target == null ? null : List.of(target), secondary == null ? null : List.of(secondary));
    }

    public void authorizeOrThrow(@Nonnull PolarisPrincipal polarisPrincipal, @Nonnull Set<PolarisBaseEntity> activatedEntities, @Nonnull PolarisAuthorizableOperation authzOp, @Nullable List<PolarisResolvedPathWrapper> targets, @Nullable List<PolarisResolvedPathWrapper> secondaries) {
        boolean allowed = this.queryOpa(polarisPrincipal, activatedEntities, authzOp, targets, secondaries);
        if (!allowed) {
            throw new ForbiddenException("OPA denied authorization", new Object[0]);
        }
    }

    private boolean queryOpa(PolarisPrincipal principal, Set<PolarisBaseEntity> entities, PolarisAuthorizableOperation op, List<PolarisResolvedPathWrapper> targets, List<PolarisResolvedPathWrapper> secondaries) {
        try {
            String token;
            String inputJson = this.buildOpaInputJson(principal, entities, op, targets, secondaries);
            HttpPost httpPost = new HttpPost(this.policyUri);
            httpPost.setHeader("Content-Type", (Object)"application/json");
            if (this.tokenProvider != null && (token = this.tokenProvider.getToken()) != null && !token.isEmpty()) {
                httpPost.setHeader("Authorization", (Object)("Bearer " + token));
            }
            httpPost.setEntity((HttpEntity)new StringEntity(inputJson, ContentType.APPLICATION_JSON));
            return (Boolean)this.httpClientExecute((ClassicHttpRequest)httpPost, this::queryOpaCheckResponse);
        }
        catch (IOException | HttpException e) {
            throw new RuntimeException("OPA query failed", e);
        }
    }

    @VisibleForTesting
    <T> T httpClientExecute(ClassicHttpRequest request, HttpClientResponseHandler<? extends T> responseHandler) throws HttpException, IOException {
        return (T)this.httpClient.execute(request, responseHandler);
    }

    private boolean queryOpaCheckResponse(ClassicHttpResponse response) throws IOException {
        String responseBody;
        int statusCode = response.getCode();
        if (statusCode != 200) {
            return false;
        }
        try {
            responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse OPA response", e);
        }
        ObjectNode respNode = (ObjectNode)this.objectMapper.readTree(responseBody);
        return respNode.path("result").path("allow").asBoolean(false);
    }

    private String buildOpaInputJson(PolarisPrincipal principal, Set<PolarisBaseEntity> entities, PolarisAuthorizableOperation op, List<PolarisResolvedPathWrapper> targets, List<PolarisResolvedPathWrapper> secondaries) throws IOException {
        ImmutableActor actor = ImmutableActor.builder().principal(principal.getName()).addAllRoles(principal.getRoles()).build();
        ArrayList<ResourceEntity> targetEntities = new ArrayList<ResourceEntity>();
        if (targets != null) {
            for (PolarisResolvedPathWrapper target : targets) {
                ResourceEntity entity = this.buildResourceEntity(target);
                if (entity == null) continue;
                targetEntities.add(entity);
            }
        }
        ArrayList<ResourceEntity> secondaryEntities = new ArrayList<ResourceEntity>();
        if (secondaries != null) {
            for (PolarisResolvedPathWrapper secondary : secondaries) {
                ResourceEntity entity = this.buildResourceEntity(secondary);
                if (entity == null) continue;
                secondaryEntities.add(entity);
            }
        }
        ImmutableResource resource = ImmutableResource.builder().targets(targetEntities).secondaries(secondaryEntities).build();
        ImmutableContext context = ImmutableContext.builder().requestId(UUID.randomUUID().toString()).build();
        ImmutableOpaAuthorizationInput input = ImmutableOpaAuthorizationInput.builder().actor(actor).action(op.name()).resource(resource).context(context).build();
        ImmutableOpaRequest request = ImmutableOpaRequest.builder().input(input).build();
        return this.objectMapper.writeValueAsString((Object)request);
    }

    @Nullable
    private ResourceEntity buildResourceEntity(@Nullable PolarisResolvedPathWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        ResolvedPolarisEntity resolvedEntity = wrapper.getResolvedLeafEntity();
        if (resolvedEntity == null) {
            return null;
        }
        PolarisEntity entity = resolvedEntity.getEntity();
        ImmutableResourceEntity.Builder builder = ImmutableResourceEntity.builder().type(entity.getType().name()).name(entity.getName());
        List parentPath = wrapper.getResolvedParentPath();
        if (parentPath != null && !parentPath.isEmpty()) {
            ArrayList<ImmutableResourceEntity> parents = new ArrayList<ImmutableResourceEntity>();
            for (ResolvedPolarisEntity parent : parentPath) {
                parents.add(ImmutableResourceEntity.builder().type(parent.getEntity().getType().name()).name(parent.getEntity().getName()).build());
            }
            builder.parents(parents);
        }
        return builder.build();
    }
}

