/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.credentials;

import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nonnull;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.ResolutionException;
import jakarta.enterprise.inject.UnsatisfiedResolutionException;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import org.apache.polaris.core.connection.AuthenticationType;
import org.apache.polaris.core.connection.ConnectionConfigInfoDpo;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.core.credentials.PolarisCredentialManager;
import org.apache.polaris.core.credentials.connection.ConnectionCredentialVendor;
import org.apache.polaris.core.credentials.connection.ConnectionCredentials;
import org.apache.polaris.service.credentials.connection.AuthType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
@Identifier(value="default")
public class DefaultPolarisCredentialManager
implements PolarisCredentialManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolarisCredentialManager.class);
    private final RealmContext realmContext;
    private final Instance<ConnectionCredentialVendor> credentialVendors;

    @Inject
    public DefaultPolarisCredentialManager(RealmContext realmContext, @Any Instance<ConnectionCredentialVendor> credentialVendors) {
        this.realmContext = realmContext;
        this.credentialVendors = credentialVendors;
    }

    public RealmContext getRealmContext() {
        return this.realmContext;
    }

    @Nonnull
    public ConnectionCredentials getConnectionCredentials(@Nonnull ConnectionConfigInfoDpo connectionConfig) {
        ConnectionCredentialVendor selectedVendor;
        AuthenticationType authType = connectionConfig.getAuthenticationParameters().getAuthenticationType();
        try {
            selectedVendor = (ConnectionCredentialVendor)this.credentialVendors.select(new Annotation[]{AuthType.Literal.of((AuthenticationType)authType)}).get();
        }
        catch (UnsatisfiedResolutionException e) {
            return ConnectionCredentials.builder().build();
        }
        catch (ResolutionException e) {
            throw new IllegalStateException("Unable to obtain connection credentials required for executing this request", e);
        }
        return selectedVendor.getConnectionCredentials(connectionConfig);
    }

    public DefaultPolarisCredentialManager() {
    }
}

