/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.metrics.registry.compact;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.seata.metrics.Clock;
import org.apache.seata.metrics.Id;
import org.apache.seata.metrics.Measurement;
import org.apache.seata.metrics.SystemClock;
import org.apache.seata.metrics.Timer;
import org.apache.seata.metrics.registry.compact.TimerValue;

public class CompactTimer
implements Timer {
    private final Id id;
    private final Id countId;
    private final Id totalId;
    private final Id maxId;
    private final Id averageId;
    private volatile TimerValue value;
    private final Clock clock;

    public CompactTimer(Id id) {
        this(id, SystemClock.INSTANCE);
    }

    public CompactTimer(Id id, Clock clock) {
        this.id = id;
        this.countId = new Id(id.getName()).withTag(id.getTags()).withTag("statistic", "count");
        this.totalId = new Id(id.getName()).withTag(id.getTags()).withTag("statistic", "total");
        this.maxId = new Id(id.getName()).withTag(id.getTags()).withTag("statistic", "max");
        this.averageId = new Id(id.getName()).withTag(id.getTags()).withTag("statistic", "average");
        this.value = new TimerValue();
        this.clock = clock;
    }

    public Id getId() {
        return this.id;
    }

    public void record(long value, TimeUnit unit) {
        this.value.record(value, unit);
    }

    public long count() {
        return this.value.getCount();
    }

    public long total() {
        return this.value.getTotal();
    }

    public long max() {
        return this.value.getMax();
    }

    public double average() {
        return this.value.getAverage();
    }

    public Iterable<Measurement> measure() {
        double time = this.clock.getCurrentMilliseconds();
        TimerValue value = this.value;
        this.value = new TimerValue();
        return Arrays.asList(new Measurement(this.countId, time, (double)value.getCount()), new Measurement(this.totalId, time, (double)value.getTotal() * 0.001), new Measurement(this.maxId, time, (double)value.getMax() * 0.001), new Measurement(this.averageId, time, value.getAverage() * 0.001));
    }
}

