/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core.enums;

import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.core.utils.StringUtils;

public final class EnvUtils {
    public static Env transformEnv(String envName) {
        if (StringUtils.isBlank(envName)) {
            return Env.UNKNOWN;
        }
        String cleanedEnvName = envName.trim().toUpperCase();
        if (cleanedEnvName.equals("PROD")) {
            return Env.PRO;
        }
        if (cleanedEnvName.equals("FWS")) {
            return Env.FAT;
        }
        try {
            return Env.valueOf(cleanedEnvName);
        }
        catch (IllegalArgumentException e) {
            return Env.UNKNOWN;
        }
    }
}

