/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.seata.core.exception.HttpRequestFilterException;
import org.apache.seata.core.rpc.netty.http.BaseHttpChannelHandler;
import org.apache.seata.core.rpc.netty.http.ControllerManager;
import org.apache.seata.core.rpc.netty.http.HttpInvocation;
import org.apache.seata.core.rpc.netty.http.ParameterParser;
import org.apache.seata.core.rpc.netty.http.RequestParseUtils;
import org.apache.seata.core.rpc.netty.http.filter.HttpFilterContext;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilterChain;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestFilterManager;
import org.apache.seata.core.rpc.netty.http.filter.HttpRequestParamWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDispatchHandler
extends BaseHttpChannelHandler<HttpRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDispatchHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        Object[] args;
        FullHttpRequest fullHttpRequest = httpRequest instanceof FullHttpRequest ? (FullHttpRequest)httpRequest : null;
        RequestParseUtils.QueryParseResult queryParseResult = RequestParseUtils.parseQuery(httpRequest.uri());
        String path = queryParseResult.getPath();
        Map<String, List<String>> queryParams = queryParseResult.getParameters();
        Map<String, List<String>> headerParams = RequestParseUtils.copyHeaders(httpRequest.headers());
        RequestParseUtils.BodyParseResult bodyParseResult = fullHttpRequest != null ? RequestParseUtils.parseBody(OBJECT_MAPPER, fullHttpRequest) : RequestParseUtils.BodyParseResult.empty();
        HttpFilterContext<HttpRequest> context = new HttpFilterContext<HttpRequest>(httpRequest, ctx, HttpUtil.isKeepAlive((HttpMessage)httpRequest) && httpRequest.protocolVersion().isKeepAliveDefault(), "HTTP/1.1", () -> new HttpRequestParamWrapper(queryParams, bodyParseResult.getFormParams(), headerParams, bodyParseResult.getJsonParams()));
        HttpInvocation httpInvocation = ControllerManager.getHttpInvocation(path);
        if (httpInvocation == null) {
            FullHttpResponse errorResponse = this.addErrorResponse(context, HttpResponseStatus.NOT_FOUND);
            this.sendErrorResponse(ctx, errorResponse, false);
            return;
        }
        context.setAttribute("httpInvocation", httpInvocation);
        context.setAttribute("httpController", httpInvocation.getController());
        context.setAttribute("handleMethod", httpInvocation.getMethod());
        ObjectNode requestDataNode = OBJECT_MAPPER.createObjectNode();
        requestDataNode.set("param", (JsonNode)ParameterParser.convertParamMap(queryParams));
        if (httpRequest.method() == HttpMethod.POST && bodyParseResult.getBodyNode() != null) {
            requestDataNode.set("body", (JsonNode)bodyParseResult.getBodyNode());
        }
        try {
            args = ParameterParser.getArgValues(httpInvocation.getParamMetaData(), httpInvocation.getMethod(), requestDataNode, context);
        }
        catch (Exception e) {
            LOGGER.error("Error parsing request arguments: {}", (Object)e.getMessage(), (Object)e);
            FullHttpResponse errorResponse = this.addErrorResponse(context, HttpResponseStatus.BAD_REQUEST);
            this.sendErrorResponse(ctx, errorResponse, false);
            return;
        }
        context.setAttribute("args", args);
        HttpRequestFilterChain filterChain = HttpRequestFilterManager.getFilterChain(this::executeFinalAction);
        HTTP_HANDLER_THREADS.execute(() -> {
            HttpFilterContext.setCurrentContext(context);
            try {
                filterChain.doFilter(context);
            }
            catch (HttpRequestFilterException e) {
                LOGGER.warn("Request blocked by filter: {}", (Object)e.getMessage());
                FullHttpResponse errorResponse = this.addErrorResponse(context, HttpResponseStatus.BAD_REQUEST);
                this.sendErrorResponse(ctx, errorResponse, false);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error during request processing: {}", (Object)e.getMessage(), (Object)e);
                FullHttpResponse errorResponse = this.addErrorResponse(context, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                this.sendErrorResponse(ctx, errorResponse, false);
            }
            finally {
                HttpFilterContext.clearCurrentContext();
            }
        });
    }

    private void executeFinalAction(HttpFilterContext<?> context) {
        HttpInvocation httpInvocation = (HttpInvocation)context.getAttribute("httpInvocation");
        Object httpController = context.getAttribute("httpController");
        Method handleMethod = (Method)context.getAttribute("handleMethod");
        Object[] args = (Object[])context.getAttribute("args");
        try {
            Object result = handleMethod.invoke(httpController, args);
            if (context.isAsync()) {
                return;
            }
            this.sendResponse(context.getContext(), context.isKeepAlive(), result, context);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Illegal argument exception: {}", (Object)e.getMessage(), (Object)e);
            FullHttpResponse errorResponse = this.addErrorResponse(context, HttpResponseStatus.BAD_REQUEST);
            this.sendErrorResponse(context.getContext(), errorResponse, false);
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while processing HTTP request: {}", (Object)e.getMessage(), (Object)e);
            FullHttpResponse errorResponse = this.addErrorResponse(context, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            this.sendErrorResponse(context.getContext(), errorResponse, false);
        }
    }

    private void sendResponse(ChannelHandlerContext ctx, boolean keepAlive, Object result, HttpFilterContext<?> context) throws JsonProcessingException {
        DefaultFullHttpResponse response;
        if (result != null) {
            byte[] body = OBJECT_MAPPER.writeValueAsBytes(result);
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])body));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.length);
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)Unpooled.EMPTY_BUFFER));
        }
        context.setResponse(response);
        if (!keepAlive) {
            ctx.writeAndFlush((Object)response).addListeners(new GenericFutureListener[]{ChannelFutureListener.CLOSE});
        } else {
            ctx.writeAndFlush((Object)response);
        }
    }

    private FullHttpResponse addErrorResponse(HttpFilterContext<?> context, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((ByteBuf)Unpooled.EMPTY_BUFFER));
        context.setResponse(response);
        return response;
    }

    private void sendErrorResponse(ChannelHandlerContext ctx, FullHttpResponse response, boolean keepAlive) {
        if (!keepAlive) {
            ctx.writeAndFlush((Object)response).addListeners(new GenericFutureListener[]{ChannelFutureListener.CLOSE});
        } else {
            ctx.writeAndFlush((Object)response);
        }
    }
}

