/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.hessian;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.serializer.hessian.HessianSerializerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="HESSIAN")
@Deprecated
public class HessianSerializer
implements Serializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HessianSerializer.class);

    public <T> byte[] serialize(T t) {
        byte[] stream = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Hessian2Output output = new Hessian2Output((OutputStream)baos);
            output.setSerializerFactory(HessianSerializerFactory.getInstance());
            output.writeObject(t);
            output.close();
            stream = baos.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Hessian encode error:{}", (Object)e.getMessage(), (Object)e);
        }
        return stream;
    }

    public <T> T deserialize(byte[] bytes) {
        Object obj = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            Hessian2Input input = new Hessian2Input((InputStream)is);
            input.setSerializerFactory(HessianSerializerFactory.getInstance());
            obj = input.readObject();
            input.close();
        }
        catch (IOException e) {
            LOGGER.error("Hessian decode error:{}", (Object)e.getMessage(), (Object)e);
        }
        return (T)obj;
    }
}

