/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.builder;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import org.apache.fory.Fory;
import org.apache.fory.builder.JITContext;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.serializer.AbstractObjectSerializer;
import org.apache.fory.serializer.CompatibleSerializerBase;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.util.Preconditions;

public interface Generated {

    public static abstract class GeneratedCompatibleSerializer
    extends CompatibleSerializerBase
    implements Generated {
        public GeneratedCompatibleSerializer(Fory fory, Class<?> type) {
            super(fory, type);
        }
    }

    public static abstract class GeneratedMetaSharedSerializer
    extends GeneratedSerializer
    implements Generated {
        public static final String SERIALIZER_FIELD_NAME = "serializer";
        public Serializer serializer;

        public GeneratedMetaSharedSerializer(Fory fory, Class<?> cls) {
            super(fory, cls);
        }

        @Override
        public void write(MemoryBuffer buffer, Object value) {
            this.serializer.write(buffer, value);
        }
    }

    public static abstract class GeneratedObjectSerializer
    extends GeneratedSerializer
    implements Generated {
        public GeneratedObjectSerializer(Fory fory, Class<?> cls) {
            super(fory, cls);
        }
    }

    public static abstract class GeneratedSerializer
    extends AbstractObjectSerializer
    implements Generated {
        public GeneratedSerializer(Fory fory, Class<?> cls) {
            super(fory, cls);
        }

        public void registerJITNotifyCallback(final Serializer subclassSerializer, Object ... serializerFieldInfos) {
            if (serializerFieldInfos.length > 0) {
                HashMap<String, Field> fieldsMap = new HashMap<String, Field>(serializerFieldInfos.length / 2);
                for (final Field field : this.getClass().getDeclaredFields()) {
                    if (field.getType() != Serializer.class) continue;
                    fieldsMap.put(field.getName(), field);
                }
                for (int i = 0; i < serializerFieldInfos.length; i += 2) {
                    Field field;
                    String serializerFieldName = (String)serializerFieldInfos[i];
                    final Class beanFieldType = (Class)serializerFieldInfos[i + 1];
                    field = Objects.requireNonNull((Field)fieldsMap.get(serializerFieldName));
                    this.fory.getJITContext().registerJITNotifyCallback(beanFieldType, new JITContext.NotifyCallback(){

                        @Override
                        public void onNotifyResult(Object result) {
                            Serializer fieldSerializer = fory.getClassResolver().getSerializer(beanFieldType);
                            Preconditions.checkState(beanFieldType == fieldSerializer.getType());
                            Preconditions.checkState(result == fieldSerializer.getClass());
                            ReflectionUtils.setObjectFieldValue((Object)subclassSerializer, field, fieldSerializer);
                        }

                        @Override
                        public void onNotifyMissed() {
                            Serializer fieldSerializer = fory.getClassResolver().getSerializer(beanFieldType);
                            ReflectionUtils.setObjectFieldValue((Object)subclassSerializer, field, fieldSerializer);
                        }
                    });
                }
            }
        }
    }
}

