/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.config;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.NotSupportYetException;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigType;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationCache;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationChangeListener;
import org.apache.seata.config.ConfigurationChangeType;
import org.apache.seata.config.ConfigurationProvider;
import org.apache.seata.config.ExtConfigurationProvider;
import org.apache.seata.config.FileConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationFactory.class);
    private static final String REGISTRY_CONF_DEFAULT = "registry";
    private static final String ENV_SYSTEM_KEY = "SEATA_ENV";
    public static final String ENV_PROPERTY_KEY = "seataEnv";
    private static final String SYSTEM_PROPERTY_SEATA_CONFIG_NAME = "seata.config.name";
    private static final String ENV_SEATA_CONFIG_NAME = "SEATA_CONFIG_NAME";
    public static volatile Configuration CURRENT_FILE_INSTANCE;
    public static volatile FileConfiguration ORIGIN_FILE_INSTANCE_REGISTRY;
    public static volatile FileConfiguration ORIGIN_FILE_INSTANCE;
    private static final String NAME_KEY = "name";
    private static final String FILE_TYPE = "file";
    private static volatile Configuration instance;

    private static void load() {
        FileConfiguration configuration = ORIGIN_FILE_INSTANCE_REGISTRY;
        Configuration extConfiguration = null;
        try {
            extConfiguration = ((ExtConfigurationProvider)EnhancedServiceLoader.load(ExtConfigurationProvider.class)).provide(configuration);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("load Configuration from :{}", (Object)(extConfiguration == null ? configuration.getClass().getSimpleName() : extConfiguration.getClass().getSimpleName()));
            }
        }
        catch (EnhancedServiceNotFoundException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("failed to load extConfiguration: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to load extConfiguration: {}", (Object)e.getMessage(), (Object)e);
        }
        CURRENT_FILE_INSTANCE = extConfiguration == null ? configuration : extConfiguration;
    }

    private static void initOriginConfiguration() {
        String envValue;
        String seataConfigName = System.getProperty(SYSTEM_PROPERTY_SEATA_CONFIG_NAME);
        if (seataConfigName == null) {
            seataConfigName = System.getenv(ENV_SEATA_CONFIG_NAME);
        }
        if (seataConfigName == null) {
            seataConfigName = REGISTRY_CONF_DEFAULT;
        }
        if ((envValue = System.getProperty(ENV_PROPERTY_KEY)) == null) {
            envValue = System.getenv(ENV_SYSTEM_KEY);
        }
        seataConfigName = envValue == null ? seataConfigName : seataConfigName + "-" + envValue;
        ORIGIN_FILE_INSTANCE_REGISTRY = new FileConfiguration(seataConfigName, false);
    }

    public static FileConfiguration getOriginFileInstanceRegistry() {
        return ORIGIN_FILE_INSTANCE_REGISTRY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (instance != null) return instance;
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (instance != null) return instance;
            instance = ConfigurationFactory.buildConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void maybeNeedOriginFileInstance() {
        if (ConfigType.File.name().equalsIgnoreCase(ConfigurationFactory.getConfigType())) {
            String pathDataId = String.join((CharSequence)".", "config", FILE_TYPE, NAME_KEY);
            String name = CURRENT_FILE_INSTANCE.getConfig(pathDataId);
            ORIGIN_FILE_INSTANCE = new FileConfiguration(name);
        }
    }

    private static String getConfigType() {
        String configTypeName = CURRENT_FILE_INSTANCE.getConfig("config.type");
        if (StringUtils.isBlank((String)configTypeName)) {
            throw new NotSupportYetException("config type can not be null");
        }
        return configTypeName;
    }

    public static Optional<FileConfiguration> getOriginFileInstance() {
        return Optional.ofNullable(ORIGIN_FILE_INSTANCE);
    }

    private static Configuration buildConfiguration() {
        Configuration springConfiguration;
        String configTypeName = ConfigurationFactory.getConfigType();
        Configuration configuration = ORIGIN_FILE_INSTANCE;
        Configuration extConfiguration = ConfigurationFactory.getSpringConfiguration();
        if (null == extConfiguration && null != (springConfiguration = ConfigurationFactory.getNonSpringConfiguration(configTypeName))) {
            configuration = springConfiguration;
        }
        try {
            Configuration configurationCache = null != extConfiguration ? ConfigurationCache.getInstance().proxy(extConfiguration) : ConfigurationCache.getInstance().proxy(configuration);
            if (null != configurationCache) {
                extConfiguration = configurationCache;
            }
        }
        catch (Exception e) {
            LOGGER.error("failed to load configurationCacheProvider:{}", (Object)e.getMessage(), (Object)e);
        }
        return null == extConfiguration ? configuration : extConfiguration;
    }

    private static Configuration getSpringConfiguration() {
        FileConfiguration configuration = ORIGIN_FILE_INSTANCE;
        if (null != configuration) {
            try {
                Configuration extConfiguration = ((ExtConfigurationProvider)EnhancedServiceLoader.load(ExtConfigurationProvider.class, (boolean)false)).provide(configuration);
                if (null != extConfiguration) {
                    return extConfiguration;
                }
            }
            catch (EnhancedServiceNotFoundException extConfiguration) {
            }
            catch (Exception exx) {
                LOGGER.error("failed to load spring configuration :{}", (Object)exx.getMessage(), (Object)exx);
            }
        }
        return null;
    }

    private static Configuration getNonSpringConfiguration(String configTypeName) {
        try {
            io.seata.config.Configuration oldConfiguration = ((io.seata.config.ConfigurationProvider)EnhancedServiceLoader.load(io.seata.config.ConfigurationProvider.class, (String)Objects.requireNonNull(configTypeName))).provide();
            if (null != oldConfiguration) {
                Configuration configurationSPIInstanceProxy = (Configuration)Proxy.newProxyInstance(ConfigurationFactory.class.getClassLoader(), new Class[]{Configuration.class}, (InvocationHandler)new OldConfigurationInvocationHandler(oldConfiguration));
                return configurationSPIInstanceProxy;
            }
        }
        catch (EnhancedServiceNotFoundException oldConfiguration) {
        }
        catch (Exception exx) {
            LOGGER.error("failed to load non-spring configuration :{}", (Object)exx.getMessage(), (Object)exx);
        }
        try {
            Configuration configuration = ((ConfigurationProvider)EnhancedServiceLoader.load(ConfigurationProvider.class, (String)Objects.requireNonNull(configTypeName), (boolean)false)).provide();
            return configuration;
        }
        catch (Exception exx) {
            LOGGER.error("failed to load non-spring configuration :{}", (Object)exx.getMessage(), (Object)exx);
            return null;
        }
    }

    public static void reload() {
        ConfigurationCache.clear();
        ConfigurationFactory.initOriginConfiguration();
        ConfigurationFactory.load();
        ConfigurationFactory.maybeNeedOriginFileInstance();
        instance = null;
        ConfigurationFactory.getInstance();
    }

    static {
        ORIGIN_FILE_INSTANCE = null;
        ConfigurationFactory.initOriginConfiguration();
        ConfigurationFactory.load();
        ConfigurationFactory.maybeNeedOriginFileInstance();
        instance = null;
    }

    static class OldConfigurationInvocationHandler
    implements InvocationHandler {
        private final io.seata.config.Configuration configuration;
        private static final String[] SIMPLE_PARAMS_METHOD_NAMES = new String[]{"getShort", "getInt", "getLong", "getDuration", "getBoolean", "getConfig", "putConfig", "getLatestConfig", "putConfigIfAbsent", "removeConfig", "getConfigFromSys"};
        private static final List<String> SIMPLE_METHOD_NAMES = Arrays.stream(SIMPLE_PARAMS_METHOD_NAMES).collect(Collectors.toList());

        public OldConfigurationInvocationHandler(io.seata.config.Configuration configuration) {
            this.configuration = configuration;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (SIMPLE_METHOD_NAMES.contains(method.getName())) {
                Class[] classes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    classes[i] = args[i].getClass();
                }
                Method oldMethod = this.configuration.getClass().getMethod(method.getName(), classes);
                return oldMethod.invoke((Object)this.configuration, args);
            }
            if ("addConfigListener".equals(method.getName()) || "removeConfigListener".equals(method.getName())) {
                if (args.length == 2 && args[1] instanceof ConfigurationChangeListener) {
                    ConfigurationChangeListener listener = (ConfigurationChangeListener)args[1];
                    OldConfigurationChangeListenerWrapper wrapper = new OldConfigurationChangeListenerWrapper(listener);
                    Method oldMethod = this.configuration.getClass().getMethod(method.getName(), String.class, io.seata.config.ConfigurationChangeListener.class);
                    return oldMethod.invoke((Object)this.configuration, args[0], wrapper);
                }
            } else if ("getConfigListeners".equals(method.getName())) {
                Method oldMethod = this.configuration.getClass().getMethod(method.getName(), String.class);
                Set listeners = (Set)oldMethod.invoke((Object)this.configuration, args);
                if (CollectionUtils.isEmpty((Collection)listeners)) {
                    return null;
                }
                HashSet<ConfigurationChangeListener> newListeners = new HashSet<ConfigurationChangeListener>();
                for (io.seata.config.ConfigurationChangeListener listener : listeners) {
                    if (!(listener instanceof OldConfigurationChangeListenerWrapper)) continue;
                    newListeners.add(((OldConfigurationChangeListenerWrapper)listener).getTargetListener());
                }
                return newListeners;
            }
            throw new NotSupportYetException(String.format("not support method:%s", method.getName()));
        }
    }

    static class OldConfigurationChangeListenerWrapper
    implements io.seata.config.ConfigurationChangeListener {
        private final ConfigurationChangeListener listener;

        public OldConfigurationChangeListenerWrapper(ConfigurationChangeListener listener) {
            this.listener = listener;
        }

        private ConfigurationChangeEvent convert(io.seata.config.ConfigurationChangeEvent event) {
            ConfigurationChangeEvent newEvent = new ConfigurationChangeEvent();
            newEvent.setDataId(event.getDataId()).setOldValue(event.getOldValue()).setNewValue(event.getNewValue()).setNamespace(event.getNamespace());
            if (event.getChangeType() != null) {
                newEvent.setChangeType(ConfigurationChangeType.values()[event.getChangeType().ordinal()]);
            }
            return newEvent;
        }

        @Override
        public void onChangeEvent(io.seata.config.ConfigurationChangeEvent event) {
            this.onProcessEvent(event);
        }

        @Override
        public void onProcessEvent(io.seata.config.ConfigurationChangeEvent event) {
            this.listener.onProcessEvent(this.convert(event));
        }

        @Override
        public void onShutDown() {
            this.listener.onShutDown();
        }

        @Override
        public ExecutorService getExecutorService() {
            return this.listener.getExecutorService();
        }

        @Override
        public void beforeEvent() {
            this.listener.beforeEvent(null);
        }

        @Override
        public void afterEvent() {
            this.listener.afterEvent(null);
        }

        public ConfigurationChangeListener getTargetListener() {
            return this.listener;
        }
    }
}

