/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.pipeconsensus;

import java.util.Map;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.RecoverProgressIndex;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;

public class PipeConsensusProcessor
implements PipeProcessor {
    private static final int DATA_NODE_ID = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();

    public void validate(PipeParameterValidator validator) throws Exception {
    }

    public void customize(PipeParameters parameters, PipeProcessorRuntimeConfiguration configuration) throws Exception {
    }

    private boolean isContainLocalData(EnrichedEvent enrichedEvent) {
        ProgressIndex progressIndex = enrichedEvent.getProgressIndex();
        if (progressIndex instanceof RecoverProgressIndex) {
            return ((RecoverProgressIndex)progressIndex).getDataNodeId2LocalIndex().containsKey(DATA_NODE_ID);
        }
        if (progressIndex instanceof HybridProgressIndex) {
            Map type2Index = ((HybridProgressIndex)progressIndex).getType2Index();
            if (!type2Index.containsKey(ProgressIndexType.RECOVER_PROGRESS_INDEX.getType())) {
                return false;
            }
            return ((RecoverProgressIndex)type2Index.get(ProgressIndexType.RECOVER_PROGRESS_INDEX.getType())).getDataNodeId2LocalIndex().containsKey(DATA_NODE_ID);
        }
        return false;
    }

    public void process(TsFileInsertionEvent tsFileInsertionEvent, EventCollector eventCollector) throws Exception {
        EnrichedEvent enrichedEvent;
        if (tsFileInsertionEvent instanceof EnrichedEvent && !((PipeTsFileInsertionEvent)tsFileInsertionEvent).isGeneratedByPipeConsensus() && this.isContainLocalData(enrichedEvent = (EnrichedEvent)tsFileInsertionEvent)) {
            eventCollector.collect((Event)tsFileInsertionEvent);
        }
    }

    public void process(TabletInsertionEvent tabletInsertionEvent, EventCollector eventCollector) throws Exception {
        EnrichedEvent enrichedEvent;
        if (tabletInsertionEvent instanceof EnrichedEvent && this.isContainLocalData(enrichedEvent = (EnrichedEvent)tabletInsertionEvent)) {
            eventCollector.collect((Event)tabletInsertionEvent);
        }
    }

    public void process(Event event, EventCollector eventCollector) throws Exception {
        EnrichedEvent enrichedEvent;
        if (event instanceof EnrichedEvent && this.isContainLocalData(enrichedEvent = (EnrichedEvent)event)) {
            eventCollector.collect(event);
        }
    }

    public void close() throws Exception {
    }
}

