/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.datastructure.tv;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.queryengine.transformation.datastructure.SerializableList;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.column.TimeColumn;
import org.apache.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class SerializableTVList
implements SerializableList {
    protected final SerializableList.SerializationRecorder serializationRecorder;
    private final TsBlockSerde serde;
    private List<Column> valueColumns;
    private List<TimeColumn> timeColumns;
    private final List<Integer> columnSizes;
    private int size;

    public static SerializableTVList construct(String queryId) {
        SerializableList.SerializationRecorder recorder = new SerializableList.SerializationRecorder(queryId);
        return new SerializableTVList(recorder);
    }

    protected SerializableTVList(SerializableList.SerializationRecorder serializationRecorder) {
        this.serializationRecorder = serializationRecorder;
        this.serde = new TsBlockSerde();
        this.columnSizes = new ArrayList<Integer>();
        this.size = 0;
        this.init();
    }

    protected static int calculateCapacity(TSDataType dataType, float memoryLimitInMB) {
        int rowLength = 8;
        switch (dataType) {
            case INT32: 
            case DATE: {
                rowLength += 4;
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                rowLength += 8;
                break;
            }
            case FLOAT: {
                rowLength += 4;
                break;
            }
            case DOUBLE: {
                rowLength += 8;
                break;
            }
            case BOOLEAN: {
                ++rowLength;
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                rowLength += 20 + SerializableList.INITIAL_BYTE_ARRAY_LENGTH_FOR_MEMORY_CONTROL;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(dataType.toString());
            }
        }
        rowLength = (int)((float)rowLength + 0.125f);
        int capacity = 1000 * (int)(memoryLimitInMB * 1048576.0f / 2.0f / (float)(rowLength * 1000));
        if (capacity <= 0) {
            throw new RuntimeException("Memory is not enough for current query.");
        }
        return capacity;
    }

    @Override
    public SerializableList.SerializationRecorder getSerializationRecorder() {
        return this.serializationRecorder;
    }

    public int getColumnCount() {
        return this.columnSizes.size();
    }

    public long getTime(int index) {
        Preconditions.checkState((index < this.size ? 1 : 0) != 0);
        long ret = 0L;
        int total = 0;
        for (TimeColumn column : this.timeColumns) {
            int length = column.getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                ret = column.getLong(offset);
                break;
            }
            total += length;
        }
        return ret;
    }

    public int getInt(int index) {
        Preconditions.checkState((index < this.size ? 1 : 0) != 0);
        int ret = 0;
        int total = 0;
        for (Column column : this.valueColumns) {
            int length = column.getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                ret = column.getInt(offset);
                break;
            }
            total += length;
        }
        return ret;
    }

    public long getLong(int index) {
        Preconditions.checkState((index < this.size ? 1 : 0) != 0);
        long ret = 0L;
        int total = 0;
        for (Column column : this.valueColumns) {
            int length = column.getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                ret = column.getLong(offset);
                break;
            }
            total += length;
        }
        return ret;
    }

    public float getFloat(int index) {
        Preconditions.checkState((index < this.size ? 1 : 0) != 0);
        float ret = 0.0f;
        int total = 0;
        for (Column column : this.valueColumns) {
            int length = column.getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                ret = column.getFloat(offset);
                break;
            }
            total += length;
        }
        return ret;
    }

    public double getDouble(int index) {
        Preconditions.checkState((index < this.size ? 1 : 0) != 0);
        double ret = 0.0;
        int total = 0;
        for (Column column : this.valueColumns) {
            int length = column.getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                ret = column.getDouble(offset);
                break;
            }
            total += length;
        }
        return ret;
    }

    public boolean getBoolean(int index) {
        Preconditions.checkState((index < this.size ? 1 : 0) != 0);
        boolean ret = false;
        int total = 0;
        for (Column column : this.valueColumns) {
            int length = column.getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                ret = column.getBoolean(offset);
                break;
            }
            total += length;
        }
        return ret;
    }

    public Binary getBinary(int index) {
        Preconditions.checkState((index < this.size ? 1 : 0) != 0);
        Binary ret = null;
        int total = 0;
        for (Column column : this.valueColumns) {
            int length = column.getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                ret = column.getBinary(offset);
                break;
            }
            total += length;
        }
        return ret;
    }

    public boolean isNull(int index) {
        Preconditions.checkState((index < this.size ? 1 : 0) != 0);
        boolean ret = false;
        int total = 0;
        for (Column column : this.valueColumns) {
            int length = column.getPositionCount();
            if (index < total + length) {
                int offset = index - total;
                ret = column.isNull(offset);
                break;
            }
            total += length;
        }
        return ret;
    }

    public TimeColumn getTimeColumn(int index) {
        Preconditions.checkState((index < this.timeColumns.size() ? 1 : 0) != 0);
        return this.timeColumns.get(index);
    }

    public Column getValueColumn(int index) {
        Preconditions.checkState((index < this.valueColumns.size() ? 1 : 0) != 0);
        return this.valueColumns.get(index);
    }

    public void putColumns(TimeColumn timeColumn, Column valueColumn) {
        this.timeColumns.add(timeColumn);
        this.valueColumns.add(valueColumn);
        int columnSize = timeColumn.getPositionCount();
        this.columnSizes.add(columnSize);
        this.size += timeColumn.getPositionCount();
    }

    public int getColumnSize(int index) {
        Preconditions.checkState((index < this.columnSizes.size() ? 1 : 0) != 0);
        return this.columnSizes.get(index);
    }

    public int getColumnIndex(int pointIndex) {
        Preconditions.checkState((pointIndex < this.size ? 1 : 0) != 0);
        int ret = -1;
        int total = 0;
        for (int i = 0; i < this.columnSizes.size(); ++i) {
            int length = this.columnSizes.get(i);
            if (pointIndex < total + length) {
                ret = i;
                break;
            }
            total += length;
        }
        return ret;
    }

    public int getTVOffsetInColumns(int index) {
        Preconditions.checkState((index < this.size ? 1 : 0) != 0);
        int ret = -1;
        int total = 0;
        for (int length : this.columnSizes) {
            if (index < total + length) {
                ret = index - total;
                break;
            }
            total += length;
        }
        return ret;
    }

    public int getLastPointIndex(int columnIndex) {
        int total = 0;
        for (int i = 0; i <= columnIndex; ++i) {
            total += this.columnSizes.get(i).intValue();
        }
        return total;
    }

    @Override
    public void release() {
        this.timeColumns = null;
        this.valueColumns = null;
    }

    @Override
    public void init() {
        this.timeColumns = new ArrayList<TimeColumn>();
        this.valueColumns = new ArrayList<Column>();
    }

    @Override
    public void serialize(PublicBAOS outputStream) throws IOException {
        int bufferSize = 0;
        bufferSize += ReadWriteIOUtils.write((int)this.timeColumns.size(), (OutputStream)outputStream);
        for (int i = 0; i < this.timeColumns.size(); ++i) {
            TimeColumn timeColumn = this.timeColumns.get(i);
            Column valueColumn = this.valueColumns.get(i);
            TsBlock tsBlock = new TsBlock(timeColumn, new Column[]{valueColumn});
            ByteBuffer buffer = this.serde.serialize(tsBlock);
            byte[] byteArray = buffer.array();
            outputStream.write(byteArray);
            bufferSize += byteArray.length;
        }
        this.serializationRecorder.setSerializedByteLength(bufferSize);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        int blockCount = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.timeColumns = new ArrayList<TimeColumn>(blockCount);
        this.valueColumns = new ArrayList<Column>(blockCount);
        for (int i = 0; i < blockCount; ++i) {
            TsBlock tsBlock = this.serde.deserialize(byteBuffer);
            TimeColumn timeColumn = tsBlock.getTimeColumn();
            Column valueColumn = tsBlock.getColumn(0);
            this.timeColumns.add(timeColumn);
            this.valueColumns.add(valueColumn);
        }
    }

    public List<TimeColumn> getTimeColumns() {
        return this.timeColumns;
    }

    public List<Column> getValueColumns() {
        return this.valueColumns;
    }
}

