<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
  -->

# Oakathons

The Oak developers hold fairly regular Oak meetups called "Oakathons."  These community-driven meetups are open to anyone working on or with Oak to attend, either in person or remotely via videoconference.

Oakathons follow loose, community-driven schedules that evolve in real time to address the needs of the group.  

## Purpose
Oakathons serve three primary purposes which all hold equal importance:

* To conduct a "state of the project" review, where we can discuss major Oak components and the strategic direction.
* To provide time and space for free-form, synchronized discussions on issues important to key project components as well as issues impacting the whole project.
* To hack on Oak itself - trying experiments, implementing new features, fixing bugs, or collaborating with others on such efforts.

Prior to each Oakathon we attempt to identify clear outcomes, both technical accomplishments and discussion results, that we intend to accomplish.

## Cadence
Oakathons take place roughly once every three months - roughly every March, June, September, and December.  They are generally held at the Adobe office in Basel, Switzerland unless otherwise specified.  Oakathons take place over four days, Monday through Thursday, with Friday being an optional extra day.

Prior to the beginning of the Oakathon, the initial schedule will be announced on oak-dev@.  This usually consists of just the starting time for the first day.  The rest of the schedule evolves throughout the week.

## Planning
Planning for an Oakathon is as follows:

* The PMC determines a specific date for the next Oakathon.  This is done usually between six and twelve weeks in advance of the selected date, to allow opportunity for remote attendees who wish to attend to obtain travel budget and make appropriate plans.
* An issue is created in the Oak issue tracker to gather input and feedback on proposed discussion topics and projects.
* The upcoming Oakathon is announced on the public mailing list (oak-dev@).
* Proposals for discussion topics or projects for the Oakathon continue to be collected in the Oakathon issue up until the Oakathon begins - and sometimes even during the Oakathon itself.
