/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.soap;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.apache.juneau.MediaType;
import org.apache.juneau.UriContext;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.soap.SoapXmlSerializer;
import org.apache.juneau.svl.VarResolverSession;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlWriter;

public class SoapXmlSerializerSession
extends XmlSerializerSession {
    private final SoapXmlSerializer ctx;

    public static Builder create(SoapXmlSerializer ctx) {
        return new Builder(AssertionUtils.assertArgNotNull("ctx", ctx));
    }

    protected SoapXmlSerializerSession(Builder builder) {
        super(builder);
        this.ctx = builder.ctx;
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return CollectionUtils.map("SOAPAction", this.getSoapAction());
    }

    public String getSoapAction() {
        return this.ctx.getSoapAction();
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws IOException, SerializeException {
        try (XmlWriter w = this.getXmlWriter(out);){
            w.append("<?xml").attr("version", "1.0").attr("encoding", "UTF-8").appendln("?>");
            w.oTag("soap", "Envelope").attr("xmlns", "soap", (Object)this.getSoapAction()).appendln(">");
            w.sTag(1, "soap", "Body").nl(1);
            this.indent += 2;
            w.flush();
            super.doSerialize(out, o);
            w.ie(1).eTag("soap", "Body").nl(1);
            w.eTag("soap", "Envelope").nl(0);
        }
    }

    public static class Builder
    extends XmlSerializerSession.Builder {
        private SoapXmlSerializer ctx;

        protected Builder(SoapXmlSerializer ctx) {
            super(AssertionUtils.assertArgNotNull("ctx", ctx));
            this.ctx = ctx;
        }

        @Override
        public <T> Builder apply(Class<T> type, Consumer<T> apply) {
            super.apply((Class)type, (Consumer)apply);
            return this;
        }

        @Override
        public SoapXmlSerializerSession build() {
            return new SoapXmlSerializerSession(this);
        }

        @Override
        public Builder debug(Boolean value) {
            super.debug(value);
            return this;
        }

        @Override
        public Builder fileCharset(Charset value) {
            super.fileCharset(value);
            return this;
        }

        @Override
        public Builder javaMethod(Method value) {
            super.javaMethod(value);
            return this;
        }

        @Override
        public Builder locale(Locale value) {
            super.locale(value);
            return this;
        }

        @Override
        public Builder mediaType(MediaType value) {
            super.mediaType(value);
            return this;
        }

        @Override
        public Builder mediaTypeDefault(MediaType value) {
            super.mediaTypeDefault(value);
            return this;
        }

        @Override
        public Builder properties(Map<String, Object> value) {
            super.properties((Map)value);
            return this;
        }

        @Override
        public Builder property(String key, Object value) {
            super.property(key, value);
            return this;
        }

        @Override
        public Builder resolver(VarResolverSession value) {
            super.resolver(value);
            return this;
        }

        @Override
        public Builder schema(HttpPartSchema value) {
            super.schema(value);
            return this;
        }

        @Override
        public Builder schemaDefault(HttpPartSchema value) {
            super.schemaDefault(value);
            return this;
        }

        @Override
        public Builder streamCharset(Charset value) {
            super.streamCharset(value);
            return this;
        }

        @Override
        public Builder timeZone(TimeZone value) {
            super.timeZone(value);
            return this;
        }

        @Override
        public Builder timeZoneDefault(TimeZone value) {
            super.timeZoneDefault(value);
            return this;
        }

        @Override
        public Builder unmodifiable() {
            super.unmodifiable();
            return this;
        }

        @Override
        public Builder uriContext(UriContext value) {
            super.uriContext(value);
            return this;
        }

        @Override
        public Builder useWhitespace(Boolean value) {
            super.useWhitespace(value);
            return this;
        }
    }
}

