/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.log.remote.storage;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.server.log.remote.storage.RemoteLogMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentId;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentMetadata;
import org.apache.kafka.server.log.remote.storage.RemoteLogSegmentState;

@InterfaceStability.Evolving
public class RemoteLogSegmentMetadataUpdate
extends RemoteLogMetadata {
    private final RemoteLogSegmentId remoteLogSegmentId;
    private final Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata;
    private final RemoteLogSegmentState state;

    public RemoteLogSegmentMetadataUpdate(RemoteLogSegmentId remoteLogSegmentId, long eventTimestampMs, Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata, RemoteLogSegmentState state, int brokerId) {
        super(brokerId, eventTimestampMs);
        this.remoteLogSegmentId = Objects.requireNonNull(remoteLogSegmentId, "remoteLogSegmentId can not be null");
        this.customMetadata = Objects.requireNonNull(customMetadata, "customMetadata can not be null");
        this.state = Objects.requireNonNull(state, "state can not be null");
    }

    public RemoteLogSegmentId remoteLogSegmentId() {
        return this.remoteLogSegmentId;
    }

    public Optional<RemoteLogSegmentMetadata.CustomMetadata> customMetadata() {
        return this.customMetadata;
    }

    public RemoteLogSegmentState state() {
        return this.state;
    }

    @Override
    public TopicIdPartition topicIdPartition() {
        return this.remoteLogSegmentId.topicIdPartition();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteLogSegmentMetadataUpdate that = (RemoteLogSegmentMetadataUpdate)o;
        return Objects.equals(this.remoteLogSegmentId, that.remoteLogSegmentId) && Objects.equals(this.customMetadata, that.customMetadata) && this.state == that.state && this.eventTimestampMs() == that.eventTimestampMs() && this.brokerId() == that.brokerId();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.remoteLogSegmentId, this.customMetadata, this.state, this.eventTimestampMs(), this.brokerId()});
    }

    public String toString() {
        return "RemoteLogSegmentMetadataUpdate{remoteLogSegmentId=" + this.remoteLogSegmentId + ", customMetadata=" + this.customMetadata + ", state=" + (Object)((Object)this.state) + ", eventTimestampMs=" + this.eventTimestampMs() + ", brokerId=" + this.brokerId() + '}';
    }
}

