/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.common.message.InitializeShareGroupStateResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.common.message.WriteShareGroupStateResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DeleteShareGroupStateResponse;
import org.apache.kafka.common.requests.InitializeShareGroupStateResponse;
import org.apache.kafka.common.requests.ReadShareGroupStateResponse;
import org.apache.kafka.common.requests.ReadShareGroupStateSummaryResponse;
import org.apache.kafka.common.requests.WriteShareGroupStateResponse;
import org.apache.kafka.server.share.persister.DeleteShareGroupStateParameters;
import org.apache.kafka.server.share.persister.DeleteShareGroupStateResult;
import org.apache.kafka.server.share.persister.GroupTopicPartitionData;
import org.apache.kafka.server.share.persister.InitializeShareGroupStateParameters;
import org.apache.kafka.server.share.persister.InitializeShareGroupStateResult;
import org.apache.kafka.server.share.persister.PartitionAllData;
import org.apache.kafka.server.share.persister.PartitionErrorData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PartitionIdData;
import org.apache.kafka.server.share.persister.PartitionIdLeaderEpochData;
import org.apache.kafka.server.share.persister.PartitionStateBatchData;
import org.apache.kafka.server.share.persister.PartitionStateData;
import org.apache.kafka.server.share.persister.PartitionStateSummaryData;
import org.apache.kafka.server.share.persister.Persister;
import org.apache.kafka.server.share.persister.PersisterStateBatch;
import org.apache.kafka.server.share.persister.PersisterStateManager;
import org.apache.kafka.server.share.persister.ReadShareGroupStateParameters;
import org.apache.kafka.server.share.persister.ReadShareGroupStateResult;
import org.apache.kafka.server.share.persister.ReadShareGroupStateSummaryParameters;
import org.apache.kafka.server.share.persister.ReadShareGroupStateSummaryResult;
import org.apache.kafka.server.share.persister.TopicData;
import org.apache.kafka.server.share.persister.WriteShareGroupStateParameters;
import org.apache.kafka.server.share.persister.WriteShareGroupStateResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStatePersister
implements Persister {
    private final PersisterStateManager stateManager;
    private static final Logger log = LoggerFactory.getLogger(DefaultStatePersister.class);

    public DefaultStatePersister(PersisterStateManager stateManager) {
        this.stateManager = stateManager;
        this.stateManager.start();
    }

    @Override
    public void stop() {
        try {
            if (this.stateManager != null) {
                this.stateManager.stop();
            }
        }
        catch (Exception e) {
            log.error("Unable to stop state manager", (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<InitializeShareGroupStateResult> initializeState(InitializeShareGroupStateParameters request) {
        try {
            DefaultStatePersister.validate(request);
        }
        catch (Exception e) {
            log.error("Unable to validate initialize state request", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
        GroupTopicPartitionData<PartitionStateData> gtp = request.groupTopicPartitionData();
        String groupId = gtp.groupId();
        HashMap futureMap = new HashMap();
        ArrayList handlers = new ArrayList();
        gtp.topicsData().forEach(topicData -> topicData.partitions().forEach(partitionData -> {
            CompletableFuture future = futureMap.computeIfAbsent(topicData.topicId(), k -> new HashMap()).computeIfAbsent(partitionData.partition(), k -> new CompletableFuture());
            PersisterStateManager persisterStateManager = this.stateManager;
            Objects.requireNonNull(persisterStateManager);
            handlers.add(persisterStateManager.new PersisterStateManager.InitializeStateHandler(groupId, topicData.topicId(), partitionData.partition(), partitionData.stateEpoch(), partitionData.startOffset(), future, null));
        }));
        for (PersisterStateManager.PersisterStateManagerHandler handler : handlers) {
            this.stateManager.enqueue(handler);
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])handlers.stream().map(PersisterStateManager.InitializeStateHandler::result).toArray(CompletableFuture[]::new));
        return combinedFuture.thenApply(v -> this.initializeResponsesToResult(futureMap));
    }

    @Override
    public CompletableFuture<WriteShareGroupStateResult> writeState(WriteShareGroupStateParameters request) {
        try {
            DefaultStatePersister.validate(request);
        }
        catch (Exception e) {
            log.error("Unable to validate write state request", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
        GroupTopicPartitionData<PartitionStateBatchData> gtp = request.groupTopicPartitionData();
        String groupId = gtp.groupId();
        HashMap futureMap = new HashMap();
        ArrayList handlers = new ArrayList();
        gtp.topicsData().forEach(topicData -> topicData.partitions().forEach(partitionData -> {
            CompletableFuture future = futureMap.computeIfAbsent(topicData.topicId(), k -> new HashMap()).computeIfAbsent(partitionData.partition(), k -> new CompletableFuture());
            log.debug("{}-{}-{}: stateEpoch - {}, leaderEpoch - {}.", new Object[]{groupId, topicData.topicId(), partitionData.partition(), partitionData.stateEpoch(), partitionData.leaderEpoch()});
            PersisterStateManager persisterStateManager = this.stateManager;
            Objects.requireNonNull(persisterStateManager);
            handlers.add(persisterStateManager.new PersisterStateManager.WriteStateHandler(groupId, topicData.topicId(), partitionData.partition(), partitionData.stateEpoch(), partitionData.leaderEpoch(), partitionData.startOffset(), partitionData.deliveryCompleteCount(), partitionData.stateBatches(), future, null));
        }));
        for (PersisterStateManager.PersisterStateManagerHandler handler : handlers) {
            this.stateManager.enqueue(handler);
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])handlers.stream().map(PersisterStateManager.WriteStateHandler::result).toArray(CompletableFuture[]::new));
        return combinedFuture.thenApply(v -> this.writeResponsesToResult(futureMap));
    }

    InitializeShareGroupStateResult initializeResponsesToResult(Map<Uuid, Map<Integer, CompletableFuture<InitializeShareGroupStateResponse>>> futureMap) {
        List<TopicData<PartitionErrorData>> topicsData = futureMap.keySet().stream().map(topicId -> {
            List partitionErrData = ((Map)futureMap.get(topicId)).entrySet().stream().map(partitionFuture -> {
                int partition = (Integer)partitionFuture.getKey();
                CompletableFuture future = (CompletableFuture)partitionFuture.getValue();
                try {
                    InitializeShareGroupStateResponse partitionResponse = (InitializeShareGroupStateResponse)future.join();
                    return ((InitializeShareGroupStateResponseData.InitializeStateResult)partitionResponse.data().results().get(0)).partitions().stream().map(partitionResult -> PartitionFactory.newPartitionErrorData(partitionResult.partition(), partitionResult.errorCode(), partitionResult.errorMessage())).toList();
                }
                catch (Exception e) {
                    log.error("Unexpected exception while initializing data in share coordinator", (Throwable)e);
                    return List.of(PartitionFactory.newPartitionErrorData(partition, Errors.UNKNOWN_SERVER_ERROR.code(), "Error initializing state in share coordinator: " + e.getMessage()));
                }
            }).flatMap(Collection::stream).toList();
            return new TopicData((Uuid)topicId, partitionErrData);
        }).toList();
        return new InitializeShareGroupStateResult.Builder().setTopicsData(topicsData).build();
    }

    WriteShareGroupStateResult writeResponsesToResult(Map<Uuid, Map<Integer, CompletableFuture<WriteShareGroupStateResponse>>> futureMap) {
        List<TopicData<PartitionErrorData>> topicsData = futureMap.keySet().stream().map(topicId -> {
            List partitionErrData = ((Map)futureMap.get(topicId)).entrySet().stream().map(partitionFuture -> {
                int partition = (Integer)partitionFuture.getKey();
                CompletableFuture future = (CompletableFuture)partitionFuture.getValue();
                try {
                    WriteShareGroupStateResponse partitionResponse = (WriteShareGroupStateResponse)future.join();
                    return ((WriteShareGroupStateResponseData.WriteStateResult)partitionResponse.data().results().get(0)).partitions().stream().map(partitionResult -> PartitionFactory.newPartitionErrorData(partitionResult.partition(), partitionResult.errorCode(), partitionResult.errorMessage())).toList();
                }
                catch (Exception e) {
                    log.error("Unexpected exception while writing data to share coordinator", (Throwable)e);
                    return List.of(PartitionFactory.newPartitionErrorData(partition, Errors.UNKNOWN_SERVER_ERROR.code(), "Error writing state to share coordinator: " + e.getMessage()));
                }
            }).flatMap(Collection::stream).toList();
            return new TopicData((Uuid)topicId, partitionErrData);
        }).toList();
        return new WriteShareGroupStateResult.Builder().setTopicsData(topicsData).build();
    }

    @Override
    public CompletableFuture<ReadShareGroupStateResult> readState(ReadShareGroupStateParameters request) {
        try {
            DefaultStatePersister.validate(request);
        }
        catch (Exception e) {
            log.error("Unable to validate read state request", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
        GroupTopicPartitionData<PartitionIdLeaderEpochData> gtp = request.groupTopicPartitionData();
        String groupId = gtp.groupId();
        HashMap futureMap = new HashMap();
        ArrayList handlers = new ArrayList();
        gtp.topicsData().forEach(topicData -> topicData.partitions().forEach(partitionData -> {
            CompletableFuture future = futureMap.computeIfAbsent(topicData.topicId(), k -> new HashMap()).computeIfAbsent(partitionData.partition(), k -> new CompletableFuture());
            PersisterStateManager persisterStateManager = this.stateManager;
            Objects.requireNonNull(persisterStateManager);
            handlers.add(persisterStateManager.new PersisterStateManager.ReadStateHandler(groupId, topicData.topicId(), partitionData.partition(), partitionData.leaderEpoch(), future, null));
        }));
        for (PersisterStateManager.PersisterStateManagerHandler handler : handlers) {
            this.stateManager.enqueue(handler);
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])handlers.stream().map(PersisterStateManager.ReadStateHandler::result).toArray(CompletableFuture[]::new));
        return combinedFuture.thenApply(v -> this.readResponsesToResult(futureMap));
    }

    ReadShareGroupStateResult readResponsesToResult(Map<Uuid, Map<Integer, CompletableFuture<ReadShareGroupStateResponse>>> futureMap) {
        List<TopicData<PartitionAllData>> topicsData = futureMap.keySet().stream().map(topicId -> {
            List partitionAllData = ((Map)futureMap.get(topicId)).entrySet().stream().map(partitionFuture -> {
                int partition = (Integer)partitionFuture.getKey();
                CompletableFuture future = (CompletableFuture)partitionFuture.getValue();
                try {
                    ReadShareGroupStateResponse partitionResponse = (ReadShareGroupStateResponse)future.join();
                    return ((ReadShareGroupStateResponseData.ReadStateResult)partitionResponse.data().results().get(0)).partitions().stream().map(partitionResult -> PartitionFactory.newPartitionAllData(partitionResult.partition(), partitionResult.stateEpoch(), partitionResult.startOffset(), partitionResult.errorCode(), partitionResult.errorMessage(), partitionResult.stateBatches().stream().map(PersisterStateBatch::from).toList())).toList();
                }
                catch (Exception e) {
                    log.error("Unexpected exception while getting data from share coordinator", (Throwable)e);
                    return List.of(PartitionFactory.newPartitionAllData(partition, -1, -1L, Errors.UNKNOWN_SERVER_ERROR.code(), "Error reading state from share coordinator: " + e.getMessage(), List.of()));
                }
            }).flatMap(Collection::stream).toList();
            return new TopicData((Uuid)topicId, partitionAllData);
        }).toList();
        return new ReadShareGroupStateResult.Builder().setTopicsData(topicsData).build();
    }

    @Override
    public CompletableFuture<DeleteShareGroupStateResult> deleteState(DeleteShareGroupStateParameters request) {
        try {
            DefaultStatePersister.validate(request);
        }
        catch (Exception e) {
            log.error("Unable to validate delete state request", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
        GroupTopicPartitionData<PartitionIdData> gtp = request.groupTopicPartitionData();
        String groupId = gtp.groupId();
        HashMap futureMap = new HashMap();
        ArrayList handlers = new ArrayList();
        gtp.topicsData().forEach(topicData -> topicData.partitions().forEach(partitionData -> {
            CompletableFuture future = futureMap.computeIfAbsent(topicData.topicId(), k -> new HashMap()).computeIfAbsent(partitionData.partition(), k -> new CompletableFuture());
            PersisterStateManager persisterStateManager = this.stateManager;
            Objects.requireNonNull(persisterStateManager);
            handlers.add(persisterStateManager.new PersisterStateManager.DeleteStateHandler(groupId, topicData.topicId(), partitionData.partition(), future, null));
        }));
        for (PersisterStateManager.PersisterStateManagerHandler handler : handlers) {
            this.stateManager.enqueue(handler);
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])handlers.stream().map(PersisterStateManager.DeleteStateHandler::result).toArray(CompletableFuture[]::new));
        return combinedFuture.thenApply(v -> this.deleteResponsesToResult(futureMap));
    }

    @Override
    public CompletableFuture<ReadShareGroupStateSummaryResult> readSummary(ReadShareGroupStateSummaryParameters request) {
        try {
            DefaultStatePersister.validate(request);
        }
        catch (Exception e) {
            log.error("Unable to validate read state summary request", (Throwable)e);
            return CompletableFuture.failedFuture(e);
        }
        GroupTopicPartitionData<PartitionIdLeaderEpochData> gtp = request.groupTopicPartitionData();
        String groupId = gtp.groupId();
        HashMap futureMap = new HashMap();
        ArrayList handlers = new ArrayList();
        gtp.topicsData().forEach(topicData -> topicData.partitions().forEach(partitionData -> {
            CompletableFuture future = futureMap.computeIfAbsent(topicData.topicId(), k -> new HashMap()).computeIfAbsent(partitionData.partition(), k -> new CompletableFuture());
            PersisterStateManager persisterStateManager = this.stateManager;
            Objects.requireNonNull(persisterStateManager);
            handlers.add(persisterStateManager.new PersisterStateManager.ReadStateSummaryHandler(groupId, topicData.topicId(), partitionData.partition(), partitionData.leaderEpoch(), future, null));
        }));
        for (PersisterStateManager.PersisterStateManagerHandler handler : handlers) {
            this.stateManager.enqueue(handler);
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf((CompletableFuture[])handlers.stream().map(PersisterStateManager.ReadStateSummaryHandler::result).toArray(CompletableFuture[]::new));
        return combinedFuture.thenApply(v -> this.readSummaryResponsesToResult(futureMap));
    }

    ReadShareGroupStateSummaryResult readSummaryResponsesToResult(Map<Uuid, Map<Integer, CompletableFuture<ReadShareGroupStateSummaryResponse>>> futureMap) {
        List<TopicData<PartitionStateSummaryData>> topicsData = futureMap.keySet().stream().map(topicId -> {
            List partitionStateErrorData = ((Map)futureMap.get(topicId)).entrySet().stream().map(partitionFuture -> {
                int partition = (Integer)partitionFuture.getKey();
                CompletableFuture future = (CompletableFuture)partitionFuture.getValue();
                try {
                    ReadShareGroupStateSummaryResponse partitionResponse = (ReadShareGroupStateSummaryResponse)future.join();
                    return ((ReadShareGroupStateSummaryResponseData.ReadStateSummaryResult)partitionResponse.data().results().get(0)).partitions().stream().map(partitionResult -> PartitionFactory.newPartitionStateSummaryData(partitionResult.partition(), partitionResult.stateEpoch(), partitionResult.startOffset(), partitionResult.deliveryCompleteCount(), partitionResult.leaderEpoch(), partitionResult.errorCode(), partitionResult.errorMessage())).toList();
                }
                catch (Exception e) {
                    log.error("Unexpected exception while getting data from share coordinator", (Throwable)e);
                    return List.of(PartitionFactory.newPartitionStateSummaryData(partition, -1, -1L, -1, -1, Errors.UNKNOWN_SERVER_ERROR.code(), "Error reading state from share coordinator: " + e.getMessage()));
                }
            }).flatMap(Collection::stream).toList();
            return new TopicData((Uuid)topicId, partitionStateErrorData);
        }).toList();
        return new ReadShareGroupStateSummaryResult.Builder().setTopicsData(topicsData).build();
    }

    DeleteShareGroupStateResult deleteResponsesToResult(Map<Uuid, Map<Integer, CompletableFuture<DeleteShareGroupStateResponse>>> futureMap) {
        List<TopicData<PartitionErrorData>> topicsData = futureMap.keySet().stream().map(topicId -> {
            List partitionErrorData = ((Map)futureMap.get(topicId)).entrySet().stream().map(partitionFuture -> {
                int partition = (Integer)partitionFuture.getKey();
                CompletableFuture future = (CompletableFuture)partitionFuture.getValue();
                try {
                    DeleteShareGroupStateResponse partitionResponse = (DeleteShareGroupStateResponse)future.join();
                    return ((DeleteShareGroupStateResponseData.DeleteStateResult)partitionResponse.data().results().get(0)).partitions().stream().map(partitionResult -> PartitionFactory.newPartitionErrorData(partitionResult.partition(), partitionResult.errorCode(), partitionResult.errorMessage())).toList();
                }
                catch (Exception e) {
                    log.error("Unexpected exception while getting data from share coordinator", (Throwable)e);
                    return List.of(PartitionFactory.newPartitionErrorData(partition, Errors.UNKNOWN_SERVER_ERROR.code(), "Error deleting state from share coordinator: " + e.getMessage()));
                }
            }).flatMap(Collection::stream).toList();
            return new TopicData((Uuid)topicId, partitionErrorData);
        }).toList();
        return new DeleteShareGroupStateResult.Builder().setTopicsData(topicsData).build();
    }

    private static void validate(InitializeShareGroupStateParameters params) {
        String prefix = "Initialize share group parameters";
        if (params == null) {
            throw new IllegalArgumentException(prefix + " cannot be null.");
        }
        if (params.groupTopicPartitionData() == null) {
            throw new IllegalArgumentException(prefix + " data cannot be null.");
        }
        DefaultStatePersister.validateGroupTopicPartitionData(prefix, params.groupTopicPartitionData());
    }

    private static void validate(WriteShareGroupStateParameters params) {
        String prefix = "Write share group parameters";
        if (params == null) {
            throw new IllegalArgumentException(prefix + " cannot be null.");
        }
        if (params.groupTopicPartitionData() == null) {
            throw new IllegalArgumentException(prefix + " data cannot be null.");
        }
        DefaultStatePersister.validateGroupTopicPartitionData(prefix, params.groupTopicPartitionData());
    }

    private static void validate(ReadShareGroupStateParameters params) {
        String prefix = "Read share group parameters";
        if (params == null) {
            throw new IllegalArgumentException(prefix + " cannot be null.");
        }
        if (params.groupTopicPartitionData() == null) {
            throw new IllegalArgumentException(prefix + " data cannot be null.");
        }
        DefaultStatePersister.validateGroupTopicPartitionData(prefix, params.groupTopicPartitionData());
    }

    private static void validate(ReadShareGroupStateSummaryParameters params) {
        String prefix = "Read share group summary parameters";
        if (params == null) {
            throw new IllegalArgumentException(prefix + " cannot be null.");
        }
        if (params.groupTopicPartitionData() == null) {
            throw new IllegalArgumentException(prefix + " data cannot be null.");
        }
        DefaultStatePersister.validateGroupTopicPartitionData(prefix, params.groupTopicPartitionData());
    }

    private static void validate(DeleteShareGroupStateParameters params) {
        String prefix = "Delete share group parameters";
        if (params == null) {
            throw new IllegalArgumentException(prefix + " cannot be null.");
        }
        if (params.groupTopicPartitionData() == null) {
            throw new IllegalArgumentException(prefix + " data cannot be null.");
        }
        DefaultStatePersister.validateGroupTopicPartitionData(prefix, params.groupTopicPartitionData());
    }

    private static void validateGroupTopicPartitionData(String prefix, GroupTopicPartitionData<? extends PartitionIdData> data) {
        String groupId = data.groupId();
        if (groupId == null || groupId.isEmpty()) {
            throw new IllegalArgumentException(prefix + " groupId cannot be null or empty.");
        }
        List<TopicData<? extends PartitionIdData>> topicsData = data.topicsData();
        if (DefaultStatePersister.isEmpty(topicsData)) {
            throw new IllegalArgumentException(prefix + " topics data cannot be null or empty.");
        }
        for (TopicData<? extends PartitionIdData> topicData : topicsData) {
            if (topicData.topicId() == null) {
                throw new IllegalArgumentException(prefix + " topicId cannot be null.");
            }
            if (DefaultStatePersister.isEmpty(topicData.partitions())) {
                throw new IllegalArgumentException(prefix + " partitions cannot be null or empty.");
            }
            for (PartitionIdData partitionIdData : topicData.partitions()) {
                if (partitionIdData.partition() >= 0) continue;
                throw new IllegalArgumentException(String.format("%s has invalid partitionId - %s %s %d", prefix, groupId, topicData.topicId(), partitionIdData.partition()));
            }
        }
    }

    private static boolean isEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }
}

