/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.spi.RouteError;

public class DefaultRouteError
implements RouteError {
    private final RouteError.Phase phase;
    private final Throwable throwable;
    private final boolean unhealthy;

    public DefaultRouteError(RouteError.Phase phase, Throwable throwable) {
        this(phase, throwable, false);
    }

    public DefaultRouteError(RouteError.Phase phase, Throwable throwable, boolean unhealthy) {
        this.phase = phase;
        this.throwable = throwable;
        this.unhealthy = unhealthy;
    }

    public RouteError.Phase getPhase() {
        return this.phase;
    }

    public Throwable getException() {
        return this.throwable;
    }

    public boolean isUnhealthy() {
        return this.unhealthy;
    }

    public static void set(CamelContext context, String routeId, RouteError.Phase phase, Throwable throwable) {
        Route route = context.getRoute(routeId);
        if (route != null) {
            route.setLastError((RouteError)new DefaultRouteError(phase, throwable));
        }
    }

    public static void set(CamelContext context, String routeId, RouteError.Phase phase, Throwable throwable, boolean unhealthy) {
        Route route = context.getRoute(routeId);
        if (route != null) {
            route.setLastError((RouteError)new DefaultRouteError(phase, throwable, unhealthy));
        }
    }

    public static void reset(CamelContext context, String routeId) {
        Route route = context.getRoute(routeId);
        if (route != null) {
            route.setLastError(null);
        }
    }
}

