/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.metrics;

import com.codahale.metrics.MetricRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.MetricsServlet;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.metrics.MetricsConf$;
import org.apache.kyuubi.metrics.PrometheusReporterService$;
import org.apache.kyuubi.service.AbstractService;
import org.apache.kyuubi.util.JavaUtils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u000b\u0017\u0001}A\u0001B\n\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\u0006a\u0001!\t!\r\u0005\bk\u0001\u0011\r\u0011\"\u00037\u0011\u0019\t\u0005\u0001)A\u0005o!Q!\t\u0001a\u0001\u0002\u0004%\tAF\"\t\u00159\u0003\u0001\u0019!a\u0001\n\u00031r\nC\u0005Y\u0001\u0001\u0007\t\u0011)Q\u0005\t\"9\u0011\f\u0001a\u0001\n#Q\u0006b\u00020\u0001\u0001\u0004%\tb\u0018\u0005\u0007C\u0002\u0001\u000b\u0015B.\t\u000b\u0019\u0004A\u0011I4\t\u000bA\u0004A\u0011I9\t\u000bI\u0004A\u0011I9\t\u000bM\u0004A\u0011B9\t\u000bQ\u0004A\u0011B;\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$\u001d9\u0011q\u0005\f\t\u0002\u0005%bAB\u000b\u0017\u0011\u0003\tY\u0003\u0003\u00041%\u0011\u0005\u00111\u0007\u0005\b\u0003k\u0011B\u0011AA\u001c\u0005e\u0001&o\\7fi\",Wo\u001d*fa>\u0014H/\u001a:TKJ4\u0018nY3\u000b\u0005]A\u0012aB7fiJL7m\u001d\u0006\u00033i\taa[=vk\nL'BA\u000e\u001d\u0003\u0019\t\u0007/Y2iK*\tQ$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005G\u0001\bg\u0016\u0014h/[2f\u0013\t)#EA\bBEN$(/Y2u'\u0016\u0014h/[2f\u0003!\u0011XmZ5tiJL\bC\u0001\u0015/\u001b\u0005I#BA\f+\u0015\tYC&\u0001\u0005d_\u0012\f\u0007.\u00197f\u0015\u0005i\u0013aA2p[&\u0011q&\u000b\u0002\u000f\u001b\u0016$(/[2SK\u001eL7\u000f\u001e:z\u0003\u0019a\u0014N\\5u}Q\u0011!\u0007\u000e\t\u0003g\u0001i\u0011A\u0006\u0005\u0006M\t\u0001\raJ\u0001\u000fEJLGmZ3SK\u001eL7\u000f\u001e:z+\u00059\u0004C\u0001\u001d@\u001b\u0005I$B\u0001\u001e<\u0003\u0019\u0019G.[3oi*\u0011A(P\u0001\u000baJ|W.\u001a;iKV\u001c(\"\u0001 \u0002\u0005%|\u0017B\u0001!:\u0005E\u0019u\u000e\u001c7fGR|'OU3hSN$(/_\u0001\u0010EJLGmZ3SK\u001eL7\u000f\u001e:zA\u0005Q\u0001\u000e\u001e;q'\u0016\u0014h/\u001a:\u0016\u0003\u0011\u0003\"!\u0012'\u000e\u0003\u0019S!a\u0012%\u0002\rM,'O^3s\u0015\tI%*A\u0003kKR$\u0018P\u0003\u0002L9\u00059Qm\u00197jaN,\u0017BA'G\u0005\u0019\u0019VM\u001d<fe\u0006q\u0001\u000e\u001e;q'\u0016\u0014h/\u001a:`I\u0015\fHC\u0001)W!\t\tF+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0005\u0011)f.\u001b;\t\u000f]3\u0011\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\u0002\u0017!$H\u000f]*feZ,'\u000fI\u0001\nSN\u001cF/\u0019:uK\u0012,\u0012a\u0017\t\u0003#rK!!\u0018*\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011n]*uCJ$X\rZ0%KF$\"\u0001\u00151\t\u000f]K\u0011\u0011!a\u00017\u0006Q\u0011n]*uCJ$X\r\u001a\u0011)\u0005)\u0019\u0007CA)e\u0013\t)'K\u0001\u0005w_2\fG/\u001b7f\u0003)Ig.\u001b;jC2L'0\u001a\u000b\u0003!\"DQ![\u0006A\u0002)\fAaY8oMB\u00111N\\\u0007\u0002Y*\u0011Q\u000eG\u0001\u0007G>tg-[4\n\u0005=d'AC&zkV\u0014\u0017nQ8oM\u0006)1\u000f^1siR\t\u0001+\u0001\u0003ti>\u0004\u0018AD:u_BDE\u000f\u001e9TKJ4XM]\u0001\"GJ,\u0017\r^3Qe>lW\r\u001e5fkN\u001cVM\u001d<mKR<\u0016\u000e\u001e5MC\n,Gn\u001d\u000b\u0004m\u0006\u0005\u0001CA<\u007f\u001b\u0005A(BA={\u0003\u0011AG\u000f\u001e9\u000b\u0005md\u0018aB:feZdW\r\u001e\u0006\u0002{\u0006)!.\u0019<bq&\u0011q\u0010\u001f\u0002\f\u0011R$\boU3sm2,G\u000fC\u0004\u0002\u0004=\u0001\r!!\u0002\u0002\r1\f'-\u001a7t!!\t9!!\u0006\u0002\u001c\u0005ma\u0002BA\u0005\u0003#\u00012!a\u0003S\u001b\t\tiAC\u0002\u0002\u0010y\ta\u0001\u0010:p_Rt\u0014bAA\n%\u00061\u0001K]3eK\u001aLA!a\u0006\u0002\u001a\t\u0019Q*\u00199\u000b\u0007\u0005M!\u000b\u0005\u0003\u0002\b\u0005u\u0011\u0002BA\u0010\u00033\u0011aa\u0015;sS:<\u0017AE4fi6+GO]5dgNs\u0017\r]:i_R$B!a\u0007\u0002&!9\u00111\u0001\tA\u0002\u0005\u0015\u0011!\u0007)s_6,G\u000f[3vgJ+\u0007o\u001c:uKJ\u001cVM\u001d<jG\u0016\u0004\"a\r\n\u0014\u0007I\ti\u0003E\u0002R\u0003_I1!!\rS\u0005\u0019\te.\u001f*fMR\u0011\u0011\u0011F\u0001\u0011CB\u0004H._#yiJ\fG*\u00192fYN$b!a\u0007\u0002:\u0005m\u0002BB\f\u0015\u0001\u0004\tY\u0002C\u0004\u0002>Q\u0001\r!a\u0007\u0002\u00111\f'-\u001a7TiJ\u0004")
public class PrometheusReporterService
extends AbstractService {
    private final MetricRegistry registry;
    private final CollectorRegistry bridgeRegistry;
    private Server httpServer;
    private volatile boolean isStarted;

    public static String applyExtraLabels(String string, String string2) {
        return PrometheusReporterService$.MODULE$.applyExtraLabels(string, string2);
    }

    private CollectorRegistry bridgeRegistry() {
        return this.bridgeRegistry;
    }

    public Server httpServer() {
        return this.httpServer;
    }

    public void httpServer_$eq(Server x$1) {
        this.httpServer = x$1;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void isStarted_$eq(boolean x$1) {
        this.isStarted = x$1;
    }

    public void initialize(KyuubiConf conf) {
        int port = BoxesRunTime.unboxToInt((Object)conf.get(MetricsConf$.MODULE$.METRICS_PROMETHEUS_PORT()));
        String contextPath = (String)conf.get(MetricsConf$.MODULE$.METRICS_PROMETHEUS_PATH());
        this.httpServer_$eq(new Server(port));
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        this.httpServer().setHandler((Handler)context);
        new DropwizardExports(this.registry).register(this.bridgeRegistry());
        if (BoxesRunTime.unboxToBoolean((Object)conf.get(MetricsConf$.MODULE$.METRICS_PROMETHEUS_LABELS_INSTANCE_ENABLED()))) {
            Map instanceLabel = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"instance"), (Object)new StringBuilder(1).append(JavaUtils.findLocalInetAddress().getCanonicalHostName()).append(":").append(port).toString())}));
            context.addServlet(new ServletHolder((Servlet)this.createPrometheusServletWithLabels((Map<String, String>)instanceLabel)), contextPath);
        } else {
            MetricsServlet metricsServlet = new MetricsServlet(this.bridgeRegistry());
            context.addServlet(new ServletHolder((Servlet)metricsServlet), contextPath);
        }
        super.initialize(conf);
    }

    public synchronized void start() {
        if (!this.isStarted()) {
            try {
                this.httpServer().start();
                this.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Prometheus metrics HTTP server has started at ").append(this.httpServer().getURI()).append(".").toString());
            }
            catch (Exception rethrow) {
                this.stopHttpServer();
                throw new KyuubiException("Cannot start prometheus metrics HTTP server", (Throwable)rethrow);
            }
            this.isStarted_$eq(true);
        }
        super.start();
    }

    public synchronized void stop() {
        if (this.isStarted()) {
            this.stopHttpServer();
            this.isStarted_$eq(false);
        }
        super.stop();
    }

    private void stopHttpServer() {
        if (this.httpServer() != null) {
            try {
                try {
                    this.httpServer().stop();
                    this.info((Function0 & Serializable & scala.Serializable)() -> "Prometheus metrics HTTP server has stopped.");
                }
                catch (Exception err) {
                    this.error((Function0 & Serializable & scala.Serializable)() -> "Cannot safely stop prometheus metrics HTTP server", err);
                }
            }
            finally {
                this.httpServer_$eq(null);
            }
            return;
        }
    }

    private HttpServlet createPrometheusServletWithLabels(Map<String, String> labels) {
        return new HttpServlet(this, labels){
            private final /* synthetic */ PrometheusReporterService $outer;
            private final Map labels$1;

            public void doGet(HttpServletRequest request, HttpServletResponse response) {
                try {
                    response.setContentType("text/plain;charset=utf-8");
                    response.setStatus(200);
                    response.getWriter().print(this.$outer.org$apache$kyuubi$metrics$PrometheusReporterService$$getMetricsSnapshot((Map<String, String>)this.labels$1));
                }
                catch (IllegalArgumentException e) {
                    response.sendError(400, e.getMessage());
                }
                catch (Exception e) {
                    this.$outer.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("GET ").append(request.getRequestURI()).append(" failed: ").append(e).toString(), e);
                    throw e;
                }
            }

            public void doTrace(HttpServletRequest req, HttpServletResponse res) {
                res.sendError(405);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.labels$1 = labels$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$doGet$1(javax.servlet.http.HttpServletRequest java.lang.Exception )}, serializedLambda);
            }
        };
    }

    public String org$apache$kyuubi$metrics$PrometheusReporterService$$getMetricsSnapshot(Map<String, String> labels) {
        StringWriter metricsSnapshotWriter = new StringWriter();
        String contentType = TextFormat.chooseContentType(null);
        TextFormat.writeFormat((String)contentType, (Writer)metricsSnapshotWriter, (Enumeration)this.bridgeRegistry().metricFamilySamples());
        String labelStr = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)labels.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new StringBuilder(3).append(k).append("=\"").append(v).append("\"").toString();
            }
            throw new MatchError((Object)tuple2);
        }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$))).mkString(",");
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])metricsSnapshotWriter.toString().split("\n"))).map((Function1 & Serializable & scala.Serializable)line -> {
            if (line.startsWith("#")) {
                return line;
            }
            String[] stringArray = line.split("\\s+", 2);
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                String metrics = (String)((SeqLike)option.get()).apply(0);
                String rest = (String)((SeqLike)option.get()).apply(1);
                String metricsWithNewLabels = PrometheusReporterService$.MODULE$.applyExtraLabels(metrics, labelStr);
                return new StringBuilder(1).append(metricsWithNewLabels).append(" ").append(rest).toString();
            }
            return line;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\n");
    }

    public PrometheusReporterService(MetricRegistry registry) {
        this.registry = registry;
        super("PrometheusReporterService");
        this.bridgeRegistry = new CollectorRegistry();
        this.isStarted = false;
    }
}

