/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kyuubi.jdbc.hive.auth.CachingKerberosAuthentication;
import org.apache.kyuubi.jdbc.hive.auth.KerberosAuthentication;

public class KerberosAuthenticationManager {
    private static final Map<String, CachingKerberosAuthentication> TGT_CACHE_AUTHENTICATION_CACHE = new ConcurrentHashMap<String, CachingKerberosAuthentication>();
    private static final Map<String, CachingKerberosAuthentication> KEYTAB_AUTHENTICATION_CACHE = new ConcurrentHashMap<String, CachingKerberosAuthentication>();

    public static CachingKerberosAuthentication getTgtCacheAuthentication(String ticketCache) {
        Objects.requireNonNull(ticketCache, "ticketCache is null");
        return TGT_CACHE_AUTHENTICATION_CACHE.computeIfAbsent(ticketCache, key -> {
            KerberosAuthentication tgtCacheAuth = new KerberosAuthentication(ticketCache);
            return new CachingKerberosAuthentication(tgtCacheAuth);
        });
    }

    public static CachingKerberosAuthentication getKeytabAuthentication(String principal, String keytab) {
        return KEYTAB_AUTHENTICATION_CACHE.computeIfAbsent(principal + ":" + keytab, key -> {
            KerberosAuthentication keytabAuth = new KerberosAuthentication(principal, keytab);
            return new CachingKerberosAuthentication(keytabAuth);
        });
    }
}

